/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vmwbrepository;

import com.vmware.vide.utils.VIDEUtilPlugin;
import com.vmware.vide.vmwbrepository.NTLMSchemeFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jcifs.util.Base64;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class HTTPClient {
    private static final int TIMEOUT = 30000;

    public static DefaultHttpClient getDefaultHTTPClient() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        SSLSocketFactory sf = new SSLSocketFactory(sslContext);
        sf.setHostnameVerifier(new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String arg0, String[] arg1, String[] arg2) throws SSLException {
            }

            public void verify(String arg0, X509Certificate arg1) throws SSLException {
            }

            public void verify(String arg0, SSLSocket arg1) throws IOException {
            }
        });
        Scheme httpsScheme = new Scheme("https", (SocketFactory)sf, 443);
        Scheme httpScheme = new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(httpsScheme);
        schemeRegistry.register(httpScheme);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        SingleClientConnManager cm = new SingleClientConnManager((HttpParams)params, schemeRegistry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        return httpClient;
    }

    public static void checkForProxy(DefaultHttpClient httpClient, String hostName, String proxyType) throws Exception {
        IProxyService proxy = VIDEUtilPlugin.getDefault().getProxyService();
        if (proxy.isProxiesEnabled()) {
            IProxyData pData = proxy.getProxyDataForHost(hostName, proxyType);
            if (pData == null) {
                return;
            }
            String proxyHost = pData.getHost();
            int proxyPort = pData.getPort();
            if (proxyHost != null && proxyPort != -1) {
                HttpHost httpProxy = new HttpHost(proxyHost, proxyPort);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxy);
            }
            String proxyUser = pData.getUserId();
            String proxyPassword = pData.getPassword();
            String proxyDomain = null;
            if (proxyUser != null && proxyPassword != null) {
                UsernamePasswordCredentials credentials = null;
                if (proxyUser.contains("\\")) {
                    String[] parts = proxyUser.split("\\\\");
                    if (parts.length < 2) {
                        throw new Exception("Incorrect format - Expected domain\\username");
                    }
                    proxyDomain = parts[0];
                    proxyUser = parts[1];
                }
                if (proxyDomain != null) {
                    httpClient.getAuthSchemes().register("ntlm", (AuthSchemeFactory)new NTLMSchemeFactory());
                    credentials = new NTCredentials(proxyUser, proxyPassword, "", proxyDomain);
                } else {
                    credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                }
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    public static void addAuthenticationHeader(HttpRequestBase request, String authKey, String identifier) throws UnsupportedEncodingException {
        String passcode = "Workbench-" + System.currentTimeMillis();
        if (authKey != null) {
            passcode = String.valueOf(passcode) + "-" + authKey;
        }
        String encodedString = URLEncoder.encode(Base64.encode((byte[])passcode.getBytes("UTF-8")), "UTF-8");
        String identifierString = URLEncoder.encode(Base64.encode((byte[])identifier.getBytes("UTF-8")), "UTF-8");
        request.addHeader("Authorization", "key=" + encodedString);
        request.addHeader("Identifier", "id=" + identifierString);
    }

    public static boolean checkForInternet() {
        try {
            DefaultHttpClient httpClient = HTTPClient.getDefaultHTTPClient();
            HTTPClient.checkForProxy(httpClient, "www.vmware.com", "http");
            HttpGet request = new HttpGet("http://www.vmware.com");
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

