/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.util.RSSNewsItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RSSContentProvider
extends Observable {
    private static String VMWARE_NEWS = "http://partnerweb.vmware.com/rss/vmwb20.xml";
    private static final String RSS_CONFIG_FILE = "/opt/vmware/vide/welcome/rss_config.xml";
    private static int MAX_NEWS_ITEMS = 5;
    private boolean disposed;
    private List<RSSNewsItem> items;
    Timer rssTimer;
    private static long PERIOD = 86400000L;

    public void createContent(String baseUrl, Writer pw) throws IOException {
        if (this.disposed) {
            return;
        }
        if (this.items == null) {
            pw.append("<p class=\"status-text\">");
            pw.append(Messages.RSS_Loading);
            pw.append("</p>\n");
        } else {
            if (this.items.size() > 0) {
                pw.append("<ul id=\"eclipse-news\">");
                int i = 0;
                while (i < this.items.size()) {
                    RSSNewsItem item = this.items.get(i);
                    pw.append("<li>");
                    pw.append("<a class=\"topicList\" href=\"");
                    pw.append(this.createExternalURL(baseUrl, item.url));
                    pw.append("\">");
                    pw.append(item.label);
                    pw.append("</a>");
                    pw.append("</li>\n");
                    ++i;
                }
            } else {
                pw.append("<p class=\"status-text\">");
                pw.append(Messages.RSS_No_news);
                pw.append("</p>\n");
            }
            pw.append("</ul>\n");
        }
    }

    public void createContent(String id, String baseUrl, Element parent) {
        if (this.disposed) {
            return;
        }
        Document dom = parent.getOwnerDocument();
        if (this.items == null) {
            Element para = dom.createElement("p");
            para.setAttribute("class", "status-text");
            para.setTextContent("Loading the news...");
            parent.appendChild(para);
        } else if (this.items.size() > 0) {
            Element para = dom.createElement("ul");
            para.setAttribute("id", "vmware-news");
            int i = 0;
            while (i < this.items.size()) {
                RSSNewsItem item = this.items.get(i);
                Element oneNews = dom.createElement("li");
                Element child = dom.createElement("a");
                child.setAttribute("class", "topicList");
                child.setAttribute("href", this.createExternalURL(baseUrl, item.url));
                child.setTextContent(item.label);
                oneNews.appendChild(child);
                para.appendChild(oneNews);
                ++i;
            }
            parent.appendChild(para);
        } else {
            Element para = dom.createElement("p");
            para.setTextContent("No news available");
            parent.appendChild(para);
        }
    }

    public void init(Observer parent) {
        this.addObserver(parent);
        this.readConfiguration(RSS_CONFIG_FILE);
        this.rssTimer = new Timer();
        this.rssTimer.schedule((TimerTask)new NewsFeed(), 0L, PERIOD);
    }

    public int getMaxNewsItems() {
        return MAX_NEWS_ITEMS;
    }

    public String getVMwareNewsUrl() {
        return VMWARE_NEWS;
    }

    public List<RSSNewsItem> getRSSItems() {
        return this.items;
    }

    private void readConfiguration(String xmlPath) {
        this.getConfigPath(xmlPath);
        File xmlFile = new File(xmlPath);
        if (xmlFile == null || !xmlFile.exists()) {
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            NodeList nodes = doc.getElementsByTagName("rss");
            if (nodes != null && nodes.getLength() > 0) {
                NodeList children = nodes.item(0).getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 1 && child.getFirstChild() != null && child.getFirstChild().getNodeType() == 3) {
                        String timer;
                        if (child.getNodeName().equals("address")) {
                            String addr = child.getFirstChild().getNodeValue();
                            if (addr != null && !addr.isEmpty()) {
                                VMWARE_NEWS = addr;
                            }
                        } else if (child.getNodeName().equals("max_lines")) {
                            String max = child.getFirstChild().getNodeValue();
                            if (max != null && !max.isEmpty()) {
                                MAX_NEWS_ITEMS = Integer.parseInt(max);
                            }
                        } else if (child.getNodeName().equals("timer_interval") && (timer = child.getFirstChild().getNodeValue()) != null && !timer.isEmpty()) {
                            PERIOD = 3600000 * Integer.parseInt(timer);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createExternalURL(String baseUrl, String url) {
        return String.valueOf(baseUrl) + url;
    }

    private void waitForFirstBootSetup() {
        while (new File("/opt/vmware/firstboot").exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public List<RSSNewsItem> createNewsItems() {
        block22: {
            this.items = Collections.synchronizedList(new ArrayList());
            InputStream in = null;
            boolean authenticator = false;
            this.waitForFirstBootSetup();
            try {
                try {
                    IProxyData data;
                    Proxy proxy = null;
                    IProxyService service = VIDERSEPlugin.getDefault().getProxyService();
                    if (service.isProxiesEnabled() && (data = service.getProxyData("HTTP")) != null) {
                        String proxyHost = data.getHost();
                        int proxyPort = data.getPort();
                        if (proxyHost != null && proxyPort != -1) {
                            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                            final String user = data.getUserId();
                            final String pass = data.getPassword();
                            if (user != null && pass != null) {
                                Authenticator.setDefault(new Authenticator(){

                                    @Override
                                    protected PasswordAuthentication getPasswordAuthentication() {
                                        return new PasswordAuthentication(user, pass.toCharArray());
                                    }
                                });
                                authenticator = true;
                            }
                        }
                    }
                    URL url = new URL(VMWARE_NEWS);
                    if (proxy != null) {
                        URLConnection connection = url.openConnection(proxy);
                        in = connection.getInputStream();
                    } else {
                        in = url.openStream();
                    }
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse(in, (DefaultHandler)new RSSHandler());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (authenticator) {
                        Authenticator.setDefault(null);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                if (authenticator) {
                    Authenticator.setDefault(null);
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            if (authenticator) {
                Authenticator.setDefault(null);
            }
        }
        return this.items;
    }

    public void dispose() {
        if (this.rssTimer != null) {
            this.rssTimer.cancel();
            this.rssTimer = null;
        }
    }

    public String getConfigPath(String fileName) {
        Location loc = Platform.getInstallLocation();
        if (loc == null) {
            return fileName;
        }
        URL url = loc.getURL();
        String installDir = url.getPath();
        String path = String.valueOf(installDir) + fileName;
        File file = new File(path);
        if (file.exists()) {
            return path;
        }
        return fileName;
    }

    class NewsFeed
    extends TimerTask {
        NewsFeed() {
        }

        @Override
        public void run() {
            if (RSSContentProvider.this.disposed) {
                return;
            }
            RSSContentProvider.this.createNewsItems();
            if (RSSContentProvider.this.disposed) {
                return;
            }
            RSSContentProvider.this.setChanged();
            RSSContentProvider.this.notifyObservers(null);
        }
    }

    private class RSSHandler
    extends DefaultHandler {
        private static final String ELEMENT_RSS = "rss";
        private static final String ELEMENT_CHANNEL = "channel";
        private static final String ELEMENT_ITEM = "item";
        private static final String ELEMENT_TITLE = "title";
        private static final String ELEMENT_LINK = "link";
        private Stack<String> stack = new Stack();
        private StringBuffer buf;
        private RSSNewsItem item;

        private RSSHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stack.push(qName);
            if ((ELEMENT_TITLE.equals(qName) || ELEMENT_LINK.equals(qName)) && this.item != null) {
                this.buf = new StringBuffer();
            } else if (ELEMENT_ITEM.equals(qName) && ELEMENT_CHANNEL.equals(this.stack.get(1)) && ELEMENT_RSS.equals(this.stack.get(0)) && this.stack.size() == 3 && RSSContentProvider.this.items.size() < MAX_NEWS_ITEMS) {
                this.item = new RSSNewsItem();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if (this.item != null) {
                if (this.buf != null) {
                    if (ELEMENT_TITLE.equals(qName)) {
                        this.item.setLabel(this.buf.toString().trim());
                        this.buf = null;
                    } else if (ELEMENT_LINK.equals(qName)) {
                        this.item.setUrl(this.buf.toString().trim());
                        this.buf = null;
                    }
                } else if (ELEMENT_ITEM.equals(qName)) {
                    if (this.item.label != null && this.item.label.length() > 0 && this.item.url != null && this.item.url.length() > 0) {
                        RSSContentProvider.this.items.add(this.item);
                    }
                    this.item = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(new String(ch, start, length));
            }
        }
    }
}

