/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtil.class);
    private final KeyStore ks;
    private final File trustStoreFile;
    private final String passPhrase;
    private boolean isModified = false;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public CertificateUtil(File trustStoreFile, String passPhrase) throws Exception {
        File paramTrustStoreFile = trustStoreFile;
        if (trustStoreFile == null || !trustStoreFile.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(String.valueOf(System.getProperty("java.home")) + SEP + "lib" + SEP + "security");
            trustStoreFile = new File(dir, "jssecacerts");
            if (!trustStoreFile.isFile()) {
                trustStoreFile = new File(dir, "cacerts");
            }
            logger.info("Parameter trustStore file '{}' did not exist, loading default JRE trustStore '{}'", (Object)paramTrustStoreFile, (Object)trustStoreFile);
        }
        this.passPhrase = passPhrase;
        this.trustStoreFile = trustStoreFile;
        char[] passphrase = passPhrase.toCharArray();
        logger.info("Loading trustStore " + trustStoreFile.getAbsolutePath() + " ...");
        FileInputStream in = new FileInputStream(trustStoreFile);
        this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
        this.ks.load(in, passphrase);
        ((InputStream)in).close();
    }

    public boolean isTrustStoreModified() {
        return this.isModified;
    }

    public KeyStore getTrustStore() {
        return this.ks;
    }

    public List<CertificateInfo> getCertificateInfo(String hostColonPort) throws Exception {
        String[] supportedSSlContexts;
        String errorMessage = "";
        ArrayList<CertificateInfo> returnList = new ArrayList<CertificateInfo>();
        String[] stringArray = supportedSSlContexts = new String[]{"TLSV1.2", "TLS"};
        int n = supportedSSlContexts.length;
        int n2 = 0;
        while (n2 < n) {
            String sslContext = stringArray[n2];
            boolean isTrusted = false;
            String[] c = hostColonPort.split(":");
            String host = c[0];
            int port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
            SSLContext context = SSLContext.getInstance(sslContext);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            logger.info("Opening " + sslContext + " connection to " + host + ":" + port + "...");
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                logger.debug("Starting SSL handshake...");
                socket.startHandshake();
                socket.close();
                logger.debug("No errors, certificate is already trusted");
                isTrusted = true;
            }
            catch (SSLException e) {
                isTrusted = false;
                logger.info("SSL certificates for host " + hostColonPort + " are NOT trusted: ", (Throwable)e);
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                if (!errorMessage.isEmpty()) {
                    errorMessage = String.valueOf(errorMessage) + "\n";
                }
                errorMessage = String.valueOf(errorMessage) + "Could not obtain " + sslContext + " server certificate chain for  " + hostColonPort;
            } else {
                int index = 0;
                X509Certificate[] x509CertificateArray = chain;
                int n3 = chain.length;
                int n4 = 0;
                while (n4 < n3) {
                    X509Certificate certificate = x509CertificateArray[n4];
                    boolean alreadyAdded = false;
                    for (CertificateInfo alreadyAddedInfo : returnList) {
                        if (!alreadyAddedInfo.CERTIFICATE.equals(certificate)) continue;
                        alreadyAdded = true;
                    }
                    if (!alreadyAdded) {
                        logger.info("Received certicate: {}", (Object)certificate.toString());
                        returnList.add(new CertificateInfo(hostColonPort, certificate, index++, isTrusted));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (returnList.isEmpty()) {
            logger.error(errorMessage);
            throw new Exception(errorMessage);
        }
        return returnList;
    }

    public void addCertificateToKeyStore(CertificateInfo certificateInfo, String alias) throws KeyStoreException {
        logger.info("Added certificate to in memory trustStore '{}' using alias '{}", (Object)this.trustStoreFile.getAbsolutePath(), (Object)alias);
        this.isModified = true;
        this.ks.setCertificateEntry(alias, certificateInfo.CERTIFICATE);
    }

    public static void setTrustStoreSystemProperties(String filePath, String passPhrase) {
        logger.info("Setting trust store system properties '{}' '{}'", (Object)filePath, (Object)passPhrase);
        System.setProperty("javax.net.ssl.trustStore", filePath);
        System.setProperty("javax.net.ssl.trustStorePassword", passPhrase);
    }

    public void writeTrustStoreToFile(String filePath, boolean setSystemProperties) throws Exception {
        File newTrustStoreFile = new File(filePath);
        if (newTrustStoreFile.isFile()) {
            newTrustStoreFile.delete();
        }
        logger.info("Persisting trustStore '{}'", (Object)newTrustStoreFile.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(newTrustStoreFile.getAbsolutePath());
        this.ks.store(out, this.passPhrase.toCharArray());
        ((OutputStream)out).close();
        if (setSystemProperties) {
            CertificateUtil.setTrustStoreSystemProperties(newTrustStoreFile.getAbsolutePath(), this.passPhrase);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            sb.append(HEXDIGITS[(b &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[b & 0xF]);
            sb.append(' ');
            ++n2;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        char SEP = File.separatorChar;
        File dir = new File(String.valueOf(System.getProperty("java.home")) + SEP + "lib" + SEP + "security");
        File trustStoreFile = new File(dir, "jssecacerts");
        if (!trustStoreFile.isFile()) {
            trustStoreFile = new File(dir, "cacerts");
        }
        CertificateUtil util = new CertificateUtil(trustStoreFile, "changeit");
        List<CertificateInfo> certificateInfoList = util.getCertificateInfo("192.168.1.129:8281");
        int index = 1;
        for (CertificateInfo info : certificateInfoList) {
            System.out.println(info.toString());
            String alias = String.format("%s-%d-%d", info.getHost(), info.getPort(), index++);
            util.addCertificateToKeyStore(info, alias);
        }
        util.writeTrustStoreToFile("/tmp/outputTrustStore.jks", true);
        System.out.println("-------------------------------------------------------------------------");
        System.out.println("CHECKING");
        CertificateUtil utilCheck = new CertificateUtil(new File("/tmp/outputTrustStore.jks"), "changeit");
        KeyStore ks = utilCheck.getTrustStore();
        System.out.println("isKeyEntry=" + ks.isKeyEntry("192.168.1.129-8281-1"));
        System.out.println("isCertificateEntry=" + ks.isCertificateEntry("192.168.1.129-8281-1"));
        List<CertificateInfo> checkCertificateInfoList = util.getCertificateInfo("192.168.1.129:8281");
        index = 1;
        for (CertificateInfo info : checkCertificateInfoList) {
            System.out.println(String.valueOf(info.IS_TRUSTED ? "TRUSTED: " : "NOT TRUSTED: ") + info.toString());
        }
    }

    public static void original_main(String[] args) throws Exception {
        int k;
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: java InstallCert <host>[:port] [passphrase]");
            return;
        }
        String[] c = args[0].split(":");
        String host = c[0];
        int port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
        String p = args.length == 1 ? "changeit" : args[1];
        char[] passphrase = p.toCharArray();
        File file = new File("jssecacerts");
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(String.valueOf(System.getProperty("java.home")) + SEP + "lib" + SEP + "security");
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        System.out.println("Loading KeyStore " + file.getAbsolutePath() + " ...");
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
        }
        catch (SSLException e) {
            System.out.println();
            e.printStackTrace(System.out);
        }
        X509Certificate[] chain = tm.chain;
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        int i = 0;
        while (i < chain.length) {
            X509Certificate cert = chain[i];
            System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            System.out.println("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            System.out.println("   sha1    " + CertificateUtil.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("   md5     " + CertificateUtil.toHexString(md5.digest()));
            System.out.println();
            ++i;
        }
        System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String line = reader.readLine().trim();
        try {
            k = line.length() == 0 ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("KeyStore not changed");
            return;
        }
        X509Certificate cert = chain[k];
        String alias = String.valueOf(host) + "-" + (k + 1);
        ks.setCertificateEntry(alias, cert);
        FileOutputStream out = new FileOutputStream("jssecacerts");
        ks.store(out, passphrase);
        ((OutputStream)out).close();
        System.out.println();
        System.out.println(cert);
        System.out.println();
        System.out.println("Added certificate to keystore 'jssecacerts' using alias '" + alias + "'");
    }

    public static class CertificateInfo {
        public final String HOST;
        public final int PORT;
        public final X509Certificate CERTIFICATE;
        public final boolean IS_TRUSTED;
        public final int INDEX;

        public CertificateInfo(String hostColonPort, X509Certificate certificate, int index, boolean isTrusted) {
            String[] c = hostColonPort.split(":");
            this.HOST = c[0];
            this.PORT = c.length == 1 ? 443 : Integer.parseInt(c[1]);
            this.CERTIFICATE = certificate;
            this.IS_TRUSTED = isTrusted;
            this.INDEX = index;
        }

        public String getHost() {
            return this.HOST;
        }

        public int getPort() {
            return this.PORT;
        }

        public String generateAlias() {
            return String.format("%s-%d-%d", this.getHost(), this.getPort(), this.INDEX);
        }

        public String getPemString() throws CertificateEncodingException {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("-----BEGIN CERTIFICATE-----\n");
            sb.append(DatatypeConverter.printBase64Binary((byte[])this.CERTIFICATE.getEncoded())).append("\n");
            sb.append("-----END CERTIFICATE-----\n");
            return sb.toString();
        }

        public String getThumbprint(String algorithm) throws NoSuchAlgorithmException, CertificateEncodingException {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(this.CERTIFICATE.getEncoded());
            return CertificateUtil.toHexString(digest.digest());
        }

        private void getSummary(StringBuilder sb) throws CertificateEncodingException, NoSuchAlgorithmException {
            sb.append("Host           : ").append(this.getHost()).append(":").append(this.getPort()).append("\n");
            sb.append("Subject        : ").append(this.CERTIFICATE.getSubjectDN()).append("\n");
            sb.append("Issuer         : ").append(this.CERTIFICATE.getIssuerDN()).append("\n");
            sb.append("SHA1 Thumbprint: ").append(this.getThumbprint("SHA1")).append("\n");
            sb.append("MD5 Thumbprint : ").append(this.getThumbprint("MD5")).append("\n");
        }

        public String getSummary() throws CertificateEncodingException, NoSuchAlgorithmException {
            StringBuilder sb = new StringBuilder(512);
            this.getSummary(sb);
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            try {
                this.getSummary(sb);
                sb.append("\n");
                sb.append(this.CERTIFICATE).append("\n");
                sb.append(this.getPemString()).append("\n");
            }
            catch (Exception e) {
                logger.error("Exception trying to dump certificate info", (Throwable)e);
            }
            return sb.toString();
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

