/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.connector.UserCredentialsConnectorService;
import com.vmware.vide.rse.ui.wizard.ESXNewConnectionWizardMainPage;
import com.vmware.vide.rse.ui.wizard.VCNewConnectionWizard;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class WindowsNewConnectionWizard
extends VCNewConnectionWizard {
    @Override
    protected ESXNewConnectionWizardMainPage createMainPage(IRSESystemType systemType) {
        ESXNewConnectionWizardMainPage page = super.createMainPage(systemType);
        page.setDefaultUserName("Administrator");
        return page;
    }

    @Override
    public boolean performFinish() {
        String password = this.esxMainPage.getPassword();
        boolean ok = super.performFinish();
        if (ok) {
            String userId;
            IConnectorService service = null;
            IConnectorService[] iConnectorServiceArray = this.getCreatedHost().getConnectorServices();
            int n = iConnectorServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService connector = iConnectorServiceArray[n2];
                if (connector instanceof UserCredentialsConnectorService) {
                    service = connector;
                    break;
                }
                ++n2;
            }
            if (service != null && (userId = this.esxMainPage.getUserName()) != null && userId.length() != 0) {
                service.setUserId(userId);
                if (password != null && password.length() != 0) {
                    if (this.esxMainPage.isSavePasswordChecked()) {
                        service.setPassword(userId, password, true, true);
                    } else {
                        service.setPassword(userId, password, false, true);
                    }
                }
            }
        }
        return ok;
    }
}

