/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.wizard.ESXUtil;
import com.vmware.vide.rse.ui.wizard.InstallMainPage;
import com.vmware.vide.rse.ui.wizard.InstallProgressPage;
import com.vmware.vide.rse.ui.wizard.InstallSummaryPage;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InstallWizard
extends Wizard {
    private InstallMainPage mainPage;
    private InstallProgressPage progressPage;
    private InstallSummaryPage summaryPage;
    private IHost initHost;
    private IFile initFile;
    private static String CONTEXT_HELP_ID = "context-install-wizard";

    public InstallWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Install Wizard");
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int actionMode = 0;
                IHost[] hosts = InstallWizard.this.summaryPage.getRebootSelectedHosts();
                if (hosts.length > 0) {
                    actionMode = 1;
                } else {
                    hosts = InstallWizard.this.summaryPage.getRestartSelectedHosts();
                    if (hosts.length > 0) {
                        actionMode = 2;
                    }
                }
                if (actionMode != 0) {
                    monitor.beginTask("", hosts.length);
                    int i = 0;
                    while (i < hosts.length) {
                        try {
                            if (actionMode == 1) {
                                InstallWizard.this.rebootSystem(hosts[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else if (actionMode == 2) {
                                InstallWizard.this.restartAgent(hosts[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addPages() {
        this.mainPage = new InstallMainPage("", "Selection Page", null);
        this.progressPage = new InstallProgressPage("", "Installation Page", null);
        this.summaryPage = new InstallSummaryPage("", "Summary Page", null);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.progressPage);
        this.addPage((IWizardPage)this.summaryPage);
        if (this.getShell() != null) {
            String contextId = String.valueOf(VIDERSEPlugin.getDefault().getHelpPluginId()) + "." + CONTEXT_HELP_ID;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), contextId);
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.summaryPage && this.summaryPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object object = selection.getFirstElement();
            if (object instanceof IHost) {
                this.initHost = (IHost)object;
            } else if (object instanceof IFile) {
                this.initFile = (IFile)object;
            }
        }
    }

    public IFile getInitFile() {
        return this.initFile;
    }

    public IHost getInitHost() {
        return this.initHost;
    }

    public IHost[] getSelectedHost() {
        return this.mainPage.getHosts();
    }

    public String getPackageFile() {
        return this.mainPage.getPackageFile();
    }

    public InstallProgressPage.InstallReport[] getReports() {
        return this.progressPage.getReports();
    }

    private void rebootSystem(IHost host, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Rebooting " + host.getAliasName(), 100);
        ESXUtil.reboot(host, monitor);
    }

    private void restartAgent(IHost host, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Restarting Host Agent on " + host.getAliasName(), 100);
        try {
            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
            if (!fss.isConnected()) {
                fss.connect(monitor, false);
            }
            RemoteProcess proc = RSEHelper.isVisor(host) ? new RemoteProcess(host, "/sbin/services.sh restart &") : new RemoteProcess(host, "service mgmt-vmware restart &");
            SequenceInputStream is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while (br.readLine() != null) {
            }
            proc.waitFor();
        }
        finally {
            monitor.done();
        }
    }
}

