/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.dialogs;

import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.wizard.ESXUtil;
import com.vmware.vide.rse.ui.wizard.PackageInstallWizard;
import com.vmware.vide.rse.ui.wizard.PackageRemoveWizard;
import com.vmware.vide.rse.util.MyTreeContentProvider;
import com.vmware.vide.rse.util.MyTreeElement;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IElementCollector;

public class PackageManagerDialog
extends TitleAreaDialog {
    private Button addButton;
    private Button removeButton;
    private final IHost host;
    private TreeViewer treeViewer;
    private boolean reboot;

    public PackageManagerDialog(Shell parentShell, IHost host) {
        super(parentShell);
        this.host = host;
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Package Manager");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Package Manager");
        this.setMessage("Install or Remove VIB Packages");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        child.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(child, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText("Packages installed on host " + this.host.getAliasName() + ":");
        this.createTreeViewer(child);
        this.createButtons(child);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 268437506);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = 200;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)new MyTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Iterator itor = ((IStructuredSelection)event.getSelection()).iterator();
                    while (itor.hasNext()) {
                        if (!(itor.next() instanceof VibPackage)) continue;
                        PackageManagerDialog.this.removeButton.setEnabled(true);
                        return;
                    }
                }
                PackageManagerDialog.this.removeButton.setEnabled(false);
            }
        });
        this.treeViewer.setInput((Object)new TreeRoot("VIB Packages"));
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(0, 128, false, false));
        this.addButton = new Button(composite, 8);
        this.addButton.setText("&Add...");
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageInstallWizard wizard = new PackageInstallWizard();
                wizard.init(PackageManagerDialog.this.host);
                WizardDialog dialog = new WizardDialog(PackageManagerDialog.this.getShell(), (IWizard)wizard);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    PackageManagerDialog.this.treeViewer.setInput((Object)new TreeRoot("VIB Packages"));
                    PackageManagerDialog.this.reboot = wizard.rebootNeeded();
                }
            }
        });
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText("&Remove...");
        data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageRemoveWizard wizard = new PackageRemoveWizard();
                wizard.init(PackageManagerDialog.this.host, (IStructuredSelection)PackageManagerDialog.this.treeViewer.getSelection());
                WizardDialog dialog = new WizardDialog(PackageManagerDialog.this.getShell(), (IWizard)wizard);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    PackageManagerDialog.this.treeViewer.setInput((Object)new TreeRoot("VIB Packages"));
                    PackageManagerDialog.this.reboot = wizard.rebootNeeded();
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&Close", true);
    }

    public void okPressed() {
        if (this.reboot && MessageDialog.openQuestion((Shell)this.getShell(), (String)this.host.getAliasName(), (String)"System needs to be rebooted for changes to take effect. Do you want to reboot the ESXi system now?")) {
            class RebootJob
            extends Job {
                public RebootJob(String name) {
                    super(name);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    return ESXUtil.reboot(PackageManagerDialog.this.host, monitor);
                }
            }
            RebootJob myJob = new RebootJob("Reboot");
            myJob.schedule();
        }
        super.okPressed();
    }

    private class TreeRoot
    extends MyTreeElement {
        public TreeRoot(String name) {
            super(name, null);
        }

        @Override
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            block17: {
                BufferedReader reader = null;
                monitor.beginTask("Collect VIB package list...", -1);
                try {
                    try {
                        String line;
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)PackageManagerDialog.this.host);
                        if (!fss.isConnected()) {
                            fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                        }
                        RemoteProcess process = new RemoteProcess(PackageManagerDialog.this.host, "esxcli software vib list");
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        process.run();
                        int i = 0;
                        while ((line = reader.readLine()) != null) {
                            if (i >= 2) {
                                String[] tokens = line.split("\\s+");
                                VibPackage entry = new VibPackage(String.valueOf(tokens[0]) + ":" + tokens[1], null);
                                collector.add((Object)entry, monitor);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        final String msg = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageManagerDialog.this.setErrorMessage(msg);
                            }
                        });
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
        }
    }

    public class VibData
    extends MyTreeElement {
        public VibData(String name, MyTreeElement parent) {
            super(name, parent);
        }

        @Override
        public boolean isContainer() {
            return false;
        }
    }

    public class VibPackage
    extends MyTreeElement {
        private static final String VENDOR_KEY = "Vendor: ";
        private String vendorName;

        public VibPackage(String name, MyTreeElement parent) {
            super(name, parent);
        }

        @Override
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            block19: {
                BufferedReader reader = null;
                monitor.beginTask("Collect VIB package info...", -1);
                try {
                    try {
                        String line;
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)PackageManagerDialog.this.host);
                        if (!fss.isConnected()) {
                            fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                        }
                        RemoteProcess process = new RemoteProcess(PackageManagerDialog.this.host, "esxcli software vib get --vibname " + object.toString());
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        process.run();
                        int i = 0;
                        while ((line = reader.readLine()) != null) {
                            if (i >= 2 && !line.isEmpty()) {
                                String l;
                                if (collector != null) {
                                    collector.add((Object)new VibData(line, this), monitor);
                                }
                                if ((l = line.trim()).startsWith(VENDOR_KEY)) {
                                    this.vendorName = l.substring(VENDOR_KEY.length());
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        final String msg = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageManagerDialog.this.setErrorMessage(msg);
                            }
                        });
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
        }

        public String getFullName() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (this.vendorName == null) {
                this.fetchDeferredChildren(this, null, (IProgressMonitor)monitor);
            }
            StringBuilder sb = new StringBuilder(this.vendorName);
            sb.append(':').append(this.toString());
            return sb.toString();
        }
    }
}

