/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.actions;

import com.vmware.vide.rse.ui.dialogs.PackageManagerDialog;
import com.vmware.vide.rse.util.RSEHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LaunchPackageManager
implements IObjectActionDelegate {
    private IHost host = null;
    private IWorkbenchPart part;

    public void run(IAction action) {
        if (RSEHelper.getResourcesSubSystem(this.host) == null) {
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)this.host.getAliasName(), (String)"This function works only with ESX/ESXi systems");
            return;
        }
        try {
            if (!RSEHelper.isESX50OrHigher(this.host)) {
                MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)this.host.getAliasName(), (String)"This function works only with ESXi 5.0 or higher");
                return;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)this.host.getAliasName(), (String)e.getLocalizedMessage());
            return;
        }
        PackageManagerDialog dialog = new PackageManagerDialog(this.part.getSite().getShell(), this.host);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        for (Object obj : (IStructuredSelection)selection) {
            if (!(obj instanceof IHost)) continue;
            this.host = (IHost)obj;
            break;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }
}

