/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.subsystems;

import com.vmware.vide.rse.RSEResources;
import com.vmware.vide.rse.connector.vIDESshConnectorService;
import com.vmware.vide.rse.connector.vIDESshConnectorServiceManager;
import com.vmware.vide.rse.service.ISDKService;
import com.vmware.vide.rse.subsystems.IResourcesSubSystem;
import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.HostSystem;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class ResourcesSubSystem
extends SubSystem
implements ICommunicationsListener,
IResourcesSubSystem {
    private ISDKService service;

    public ResourcesSubSystem(IHost host, IConnectorService connectorService, ISDKService service) {
        super(host, connectorService);
        this.service = service;
        connectorService.addCommunicationsListener((ICommunicationsListener)this);
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getSDKService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.service == null || filterString == null) {
            return null;
        }
        HttpLogger.logActivity((String)"rse", (String)"OpenESXObjectType", (String)filterString);
        if (filterString.equals(RSEResources.TypeInfo_VirtualMachine)) {
            return this.service.getVirtualMachineList();
        }
        if (filterString.equals(RSEResources.TypeInfo_SCSILun)) {
            return this.service.getSCSILunList();
        }
        if (filterString.equals(RSEResources.TypeInfo_HBA)) {
            return this.service.getHBAList();
        }
        if (filterString.equals(RSEResources.TypeInfo_DataStore)) {
            return this.service.getDataStoreList();
        }
        if (filterString.equals(RSEResources.TypeInfo_VSwitch)) {
            return this.service.getVSwtichList();
        }
        if (filterString.equals(RSEResources.TypeInfo_PNic)) {
            return this.service.getPNicList();
        }
        return null;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 5: {
                this.getSDKService().uninitService((IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public ISDKService getSDKService() {
        return this.service;
    }

    public void setSDKService(ISDKService service) {
        this.service = service;
    }

    public HostSystem getHostSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.service.getHostSystem();
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public boolean promptForPassword(boolean force) throws Exception {
        SystemSignonInformation info;
        String password;
        IConnectorService sconnector;
        IRemoteFileSubSystem fss;
        IConnectorService rconnector = this.getConnectorService();
        if (!rconnector.hasPassword(true) && (fss = RemoteFileUtility.getFileSubSystem((IHost)this._host)) != null && fss.isConnected() && (sconnector = fss.getConnectorService()) instanceof vIDESshConnectorService && (password = (info = ((vIDESshConnectorService)sconnector).getSignonInfo()).getPassword()) != null) {
            rconnector.setPassword(this.getUserId(), password, false, false);
        }
        if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
            return false;
        }
        return super.promptForPassword(force);
    }
}

