/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.subsystems;

import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.connector.ResourcesConnectorServiceManager;
import com.vmware.vide.rse.service.ISDKService;
import com.vmware.vide.rse.service.vIDESDKService;
import com.vmware.vide.rse.subsystems.InventorySubSystem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.services.IService;

public class InventorySubSystemConfiguration
extends SubSystemConfiguration {
    private Map services = new HashMap();

    public ISubSystem createSubSystemInternal(IHost conn) {
        IConnectorService connectorService = this.getConnectorService(conn);
        return new InventorySubSystem(conn, connectorService, this.getSDKService(conn));
    }

    public IConnectorService getConnectorService(IHost host) {
        ResourcesConnectorServiceManager manager = ResourcesConnectorServiceManager.getInstance();
        return manager.getConnectorService(host, ISDKService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        ResourcesConnectorServiceManager manager = ResourcesConnectorServiceManager.getInstance();
        manager.setConnectorService(host, ISDKService.class, connectorService);
    }

    public final IService getService(IHost host) {
        return this.getSDKService(host);
    }

    private final ISDKService getSDKService(IHost host) {
        ISDKService service = (ISDKService)this.services.get(host);
        if (service == null) {
            service = this.createSDKService(host);
            this.services.put(host, service);
        }
        return service;
    }

    private ISDKService createSDKService(IHost host) {
        ResourcesConnectorService conn = (ResourcesConnectorService)this.getConnectorService(host);
        return new vIDESDKService(conn);
    }
}

