/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.service;

import com.vmware.vide.rse.service.vIDEFileService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VMWBLSEntry
implements Comparable {
    private String filename;
    private String permission;
    private String uid;
    private String gid;
    private String size;
    private String mtime;

    VMWBLSEntry(String line) {
        boolean isSpecial = false;
        int idx1 = line.indexOf(32);
        this.permission = line.substring(0, idx1);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        if (this.permission.startsWith("b") || this.permission.startsWith("c")) {
            isSpecial = true;
        }
        idx1 = line.indexOf(32, idx1);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        int idx2 = line.indexOf(32, idx1);
        this.uid = line.substring(idx1, idx2);
        while (line.charAt(idx2) == ' ') {
            ++idx2;
        }
        idx1 = line.indexOf(32, idx2);
        this.gid = line.substring(idx2, idx1);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        if (isSpecial) {
            this.size = "0";
            idx2 = line.indexOf(32, idx1);
            while (line.charAt(idx2) == ' ') {
                ++idx2;
            }
            idx2 = line.indexOf(32, idx2);
            while (line.charAt(idx2) == ' ') {
                ++idx2;
            }
        } else {
            idx2 = line.indexOf(32, idx1);
            this.size = line.substring(idx1, idx2);
            while (line.charAt(idx2) == ' ') {
                ++idx2;
            }
        }
        idx1 = line.indexOf(32, idx2);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        idx1 = line.indexOf(32, idx1);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        idx1 = line.indexOf(32, idx1);
        this.mtime = line.substring(idx2, idx1);
        while (line.charAt(idx1) == ' ') {
            ++idx1;
        }
        this.filename = line.substring(idx1);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPermissionsString() {
        return this.permission;
    }

    public String getUId() {
        return this.uid;
    }

    public String getGId() {
        return this.gid;
    }

    public long getSize() {
        return Long.parseLong(this.size);
    }

    public long getMtime() {
        String[] array = this.mtime.split("\\s+");
        SimpleDateFormat df = array[2].indexOf(58) > 0 ? new SimpleDateFormat("MMM dd HH:mm") : new SimpleDateFormat("MMM dd yyyy");
        try {
            Date date = df.parse(String.valueOf(array[0]) + " " + array[1] + " " + array[2]);
            if (array[2].indexOf(58) > 0) {
                date.setYear(new Date().getYear());
            }
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    boolean isLink() {
        return this.permission.startsWith("l");
    }

    boolean isDir() {
        return this.permission.startsWith("d");
    }

    public vIDEFileService.MinFileATTR getFileAttr() {
        return new vIDEFileService.MinFileATTR(this.isDir(), this.isLink(), this.getMtime(), this.getSize(), this.getPermissionsString(), this.getUId(), this.getGId());
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o instanceof VMWBLSEntry) {
            return this.filename.compareTo(((VMWBLSEntry)o).getFilename());
        }
        throw new ClassCastException("Not a VMWBLSEntry.");
    }
}

