/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vide.rse.RSEResources;
import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vide.rse.ui.actions.ConfigureRemoteDisplay;
import com.vmware.vide.rse.ui.actions.LaunchRemoteDisplay;
import com.vmware.vide.rse.ui.actions.VirtualMachineElementAction;
import com.vmware.vim25.VirtualMachineConnectionState;
import com.vmware.vim25.VirtualMachinePowerState;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class VirtualMachineElementAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    private final String[][] propertySets = new String[][]{{"vm_guestid", "Guest OS", "GuestOS ID"}, {"vm_fullname", "Full Name", "Full Name of GuestOS"}, {"vm_file", "File", "VMX File path"}, {"vm_memory", "Memory", "Memory Size"}, {"vm_numcpu", "numCPU", "Number of CPUs"}, {"vm_power", "Power", "Power state"}, {"vm_hostname", "HostName", "Host Name - available only when running"}, {"vm_ipaddr", "IP Address", "IP Address - available only when running"}, {"vm_tools", "Tools Status", "VMware tools status"}};
    private static final String VM_GUESTID = "vm_guestid";
    private static final String VM_FULLNAME = "vm_fullname";
    private static final String VM_FILE = "vm_file";
    private static final String VM_MEMORY = "vm_memory";
    private static final String VM_NUMCPU = "vm_numcpu";
    private static final String VM_POWER = "vm_power";
    private static final String VM_HOSTNAME = "vm_hostname";
    private static final String VM_IPADDR = "vm_ipaddr";
    private static final String VM_TOOLS = "vm_tools";
    private VirtualMachineElementAction powerOn = null;
    private VirtualMachineElementAction powerOff = null;
    private VirtualMachineElementAction powerSuspend = null;
    private VirtualMachineElementAction powerReset = null;
    private LaunchRemoteDisplay remoteDisplay = null;
    private ConfigureRemoteDisplay configureDisplay = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
        Object element = selection.getFirstElement();
        if (element instanceof VirtualMachineElement) {
            VirtualMachineConnectionState conn = ((VirtualMachineElement)((Object)element)).getConnectionState();
            if (conn != VirtualMachineConnectionState.connected) {
                return;
            }
            VirtualMachinePowerState state = ((VirtualMachineElement)((Object)element)).getPowerState();
            if (state != VirtualMachinePowerState.poweredOn) {
                if (this.powerOn == null) {
                    this.powerOn = new VirtualMachineElementAction("Power On", "Power on virtual Machine", VIDERSEPlugin.getDefault().getImageDescriptor("action_poweron"), parent);
                }
                menu.add(menuGroup, (IAction)this.powerOn);
            }
            if (state != VirtualMachinePowerState.poweredOff && state != VirtualMachinePowerState.suspended) {
                if (this.powerOff == null) {
                    this.powerOff = new VirtualMachineElementAction("Power Off", "Power off virtual Machine", VIDERSEPlugin.getDefault().getImageDescriptor("action_poweroff"), parent);
                }
                menu.add(menuGroup, (IAction)this.powerOff);
                if (this.powerSuspend == null) {
                    this.powerSuspend = new VirtualMachineElementAction("Suspend", "Suspend virtual Machine", VIDERSEPlugin.getDefault().getImageDescriptor("action_suspend4"), parent);
                }
                menu.add(menuGroup, (IAction)this.powerSuspend);
                if (this.powerReset == null) {
                    this.powerReset = new VirtualMachineElementAction("Reset", "Reset virtual Machine", VIDERSEPlugin.getDefault().getImageDescriptor("action_reset"), parent);
                }
                menu.add(menuGroup, (IAction)this.powerReset);
            }
            if (this.configureDisplay == null) {
                this.configureDisplay = new ConfigureRemoteDisplay("Configure Remote Display", "Configure Remote Display", VIDERSEPlugin.getDefault().getImageDescriptor("action_configure"), parent);
            }
            menu.add("additions", (IAction)this.configureDisplay);
            if (this.remoteDisplay == null) {
                this.remoteDisplay = new LaunchRemoteDisplay("Launch Remote Display", "Launch Remote Display", VIDERSEPlugin.getDefault().getImageDescriptor("action_console"), parent);
            }
            menu.add("additions", (IAction)this.remoteDisplay);
        }
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        VirtualMachinePowerState state = ((VirtualMachineElement)((Object)element)).getPowerState();
        if (state == VirtualMachinePowerState.poweredOn) {
            return VIDERSEPlugin.getDefault().getImageDescriptor("status_poweredon");
        }
        if (state == VirtualMachinePowerState.poweredOff) {
            return VIDERSEPlugin.getDefault().getImageDescriptor("status_poweredoff");
        }
        if (state == VirtualMachinePowerState.suspended) {
            return VIDERSEPlugin.getDefault().getImageDescriptor("status_suspended");
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public String getType(Object element) {
        return RSEResources.VMList_FilterType;
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.internalGetPropertyDescriptors();
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return VIDERSEPlugin.getDefault().createPropertyDescripters(this.propertySets);
    }

    protected Object internalGetPropertyValue(Object key) {
        VirtualMachineElement element = (VirtualMachineElement)((Object)this.propertySourceInput);
        if (key.equals(VM_GUESTID)) {
            return element.getGuestId();
        }
        if (key.equals(VM_FULLNAME)) {
            return element.getGuestFullName();
        }
        if (key.equals(VM_FILE)) {
            return element.getVmxPath();
        }
        if (key.equals(VM_MEMORY)) {
            return element.getMemorySizeMB();
        }
        if (key.equals(VM_NUMCPU)) {
            return element.getNumCpu();
        }
        if (key.equals(VM_POWER)) {
            return element.getPowerState();
        }
        if (key.equals(VM_HOSTNAME)) {
            return element.getHostName();
        }
        if (key.equals(VM_IPADDR)) {
            return element.getIpAddress();
        }
        if (key.equals(VM_TOOLS)) {
            return element.getToolsStatus();
        }
        return null;
    }

    public String getText(Object element) {
        StringBuffer buffer = new StringBuffer(element.toString());
        VirtualMachineConnectionState state = ((VirtualMachineElement)((Object)element)).getConnectionState();
        if (state != VirtualMachineConnectionState.connected) {
            buffer.append(" (");
            buffer.append(state);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getAbsoluteName(Object object) {
        return object.toString();
    }

    public String getAbsoluteParentName(Object element) {
        return null;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getSubSystemConfigurationId(Object element) {
        return "vide.rse.subsystem.resources";
    }

    public String getName(Object element) {
        return element.toString();
    }
}

