/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vim25.HostNetworkPolicy;
import com.vmware.vim25.HostNicOrderPolicy;
import com.vmware.vim25.HostNicTeamingPolicy;
import com.vmware.vim25.HostPortGroup;
import com.vmware.vim25.HostPortGroupPort;
import com.vmware.vim25.HostPortGroupSpec;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class PortGroupElement
extends AbstractResource {
    private HostPortGroup portGroup;

    public PortGroupElement(HostPortGroup port, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.portGroup = port;
    }

    public String getName() {
        if (this.portGroup != null) {
            return this.portGroup.getSpec().getName();
        }
        return null;
    }

    public Integer getVLanId() {
        HostPortGroupSpec spec;
        if (this.portGroup != null && (spec = this.portGroup.getSpec()) != null) {
            return new Integer(spec.getVlanId());
        }
        return null;
    }

    public String getUsedPorts() {
        if (this.portGroup != null) {
            HostPortGroupPort[] ports = this.portGroup.getPort();
            if (ports != null) {
                return new Integer(ports.length).toString();
            }
            return new Integer(0).toString();
        }
        return null;
    }

    public List getUplinks() {
        HostNicTeamingPolicy team;
        HostNetworkPolicy policy;
        if (this.portGroup != null && (policy = this.portGroup.getComputedPolicy()) != null && (team = policy.getNicTeaming()) != null) {
            HostNicOrderPolicy order = team.getNicOrder();
            String[] nics = order.getActiveNic();
            ArrayList<String> nicList = new ArrayList<String>();
            int i = 0;
            while (i < nics.length) {
                nicList.add(nics[i]);
                ++i;
            }
            return nicList;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

