/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.PhysicalNicLinkInfo;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class PNicElement
extends AbstractResource {
    private PhysicalNic pnic;

    public PNicElement(PhysicalNic pnic, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.pnic = pnic;
    }

    public String getName() {
        if (this.pnic != null) {
            return this.pnic.getDevice();
        }
        return null;
    }

    public String getMAC() {
        if (this.pnic != null) {
            return this.pnic.getMac();
        }
        return null;
    }

    public String getDriver() {
        if (this.pnic != null) {
            return this.pnic.getDriver();
        }
        return null;
    }

    public String getPCI() {
        if (this.pnic != null) {
            return this.pnic.getPci();
        }
        return null;
    }

    public String getSpeed() {
        PhysicalNicLinkInfo linkInfo;
        if (this.pnic != null && (linkInfo = this.pnic.getLinkSpeed()) != null) {
            Integer speed = new Integer(linkInfo.getSpeedMb());
            return String.valueOf(speed.toString()) + " Mbps";
        }
        return null;
    }

    public String getDuplex() {
        if (this.pnic != null) {
            if (this.pnic.getLinkSpeed().isDuplex()) {
                return "Full";
            }
            return "Half";
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

