/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vide.rse.model.ClusterElement;
import com.vmware.vide.rse.model.DataCenterElement;
import com.vmware.vide.rse.model.HostSystemElement;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class FolderElement
extends AbstractResource {
    private Folder folder;
    private String name;

    public FolderElement(Folder folder, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.folder = folder;
    }

    public boolean hasChidren() {
        return true;
    }

    public Object[] getChildren(IProgressMonitor monitor) {
        ArrayList<AbstractResource> list = new ArrayList<AbstractResource>();
        try {
            ManagedEntity[] entities;
            ManagedEntity[] managedEntityArray = entities = this.folder.getChildEntity();
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                ManagedEntity entity = managedEntityArray[n2];
                if (entity instanceof Folder) {
                    list.add(new FolderElement((Folder)entity, this.getSubSystem()));
                } else if (entity instanceof Datacenter) {
                    list.add(new DataCenterElement((Datacenter)entity, this.getSubSystem()));
                } else if (entity instanceof ClusterComputeResource) {
                    list.add(new ClusterElement((ClusterComputeResource)entity, this.getSubSystem()));
                } else if (entity instanceof ComputeResource) {
                    HostSystem[] hostSystems = ((ComputeResource)entity).getHosts();
                    list.add(new HostSystemElement(hostSystems[0], this.getSubSystem(), false));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.toArray();
    }

    public String toString() {
        if (this.name == null) {
            this.name = this.folder.getName();
        }
        return this.name;
    }
}

