/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.connector;

import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;

public class ResourcesConnectorService
extends StandardConnectorService {
    private static final String CONNECTOR_SERVICE_NAME = "ESX SDK Connector Service";
    private static final String CONNECTOR_SERVICE_DESC = "ESX SDK Connector Service";
    private static final long TIME_PERIOD = 1500000L;
    private ServiceInstance serviceInstance;
    private SshConnectorService.SessionLostHandler lostHandler = null;
    private Timer connectionHandler;

    public ResourcesConnectorService(IHost host) {
        super("ESX SDK Connector Service", "ESX SDK Connector Service", host, 0);
    }

    protected void preConnect() {
        PropertySet set = (PropertySet)this.getHost().getPropertySet("ESX Properties");
        if (set != null) {
            set.setDirty(true);
        }
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        this.fireCommunicationsEvent(1);
        StringBuffer url = new StringBuffer("https://");
        url.append(this.getHostName());
        url.append("/sdk");
        String user = this.getUserId();
        String pass = "";
        SystemSignonInformation ssi = this.getSignonInformation();
        if (ssi != null) {
            pass = ssi.getPassword();
        }
        try {
            this.serviceInstance = new ServiceInstance(new URL(url.toString()), user, pass, true);
        }
        catch (InvalidLogin ie) {
            this.clearPassword(false, true);
            IRSESystemType type = this.getHost().getSystemType();
            PasswordPersistenceManager manager = PasswordPersistenceManager.getInstance();
            if (manager.passwordExists(type, this.getHostName(), this.getUserId())) {
                manager.remove(type, this.getHostName(), this.getUserId());
            }
            throw new SystemOperationFailedException((Exception)((Object)ie));
        }
        this.lostHandler = new SshConnectorService.SessionLostHandler((IConnectorService)this);
        this.notifyConnection();
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        boolean sessionLost = this.lostHandler != null && this.lostHandler.isSessionLost();
        this.lostHandler = null;
        if (this.connectionHandler != null) {
            this.connectionHandler.cancel();
            this.connectionHandler = null;
        }
        if (sessionLost) {
            this.notifyError();
            this.serviceInstance = null;
        } else {
            this.fireCommunicationsEvent(3);
            if (this.serviceInstance != null) {
                this.serviceInstance.getServerConnection().logout();
                this.serviceInstance = null;
            }
        }
        this.notifyDisconnection();
    }

    public boolean isConnected() {
        if (this.serviceInstance != null) {
            return true;
        }
        if (this.lostHandler != null) {
            this.lostHandler.sessionLost();
        }
        return false;
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUserId() {
        return false;
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    public SystemSignonInformation getSignonInfo() {
        return this.getSignonInformation();
    }

    public void handleSessionLost() {
        if (this.lostHandler != null) {
            this.lostHandler.sessionLost();
        }
    }

    private class ConnectionKeeper
    extends TimerTask {
        private ConnectionKeeper() {
        }

        @Override
        public void run() {
            if (ResourcesConnectorService.this.serviceInstance != null) {
                try {
                    ResourcesConnectorService.this.serviceInstance.currentTime();
                    return;
                }
                catch (Exception exception) {}
            }
            if (ResourcesConnectorService.this.lostHandler != null) {
                ResourcesConnectorService.this.lostHandler.sessionLost();
            }
        }
    }
}

