/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.vmware.vide.rse.api.impl.Target;
import com.vmware.vide.rse.api.impl.TargetFactory;
import com.vmware.vide.rse.connector.vIDESshConnectorServiceManager;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetChangedEvent;
import com.vmware.vide.target.api.ITargetListener;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.ITargetManagerInitListener;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vide.target.api.TargetTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetManager
implements ITargetManager,
ISystemResourceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TargetManager.class);
    private final ISystemRegistry systemRegistry;
    private final IRSECoreRegistry systemCoreRegistry;
    private final List<ITargetListener> hostListeners;
    private final TargetTypeRegistry targetTypeRegistry = new TargetTypeRegistry();

    private void loadAvailableTargetTypes() {
        ArrayList<TargetType> availableTargetTypes = new ArrayList<TargetType>();
        availableTargetTypes.add(new TargetType("localhost", "Connection for Localhost", true, "org.eclipse.rse.systemtype.local", false));
        availableTargetTypes.add(new TargetType("esx", "Connection for VMware ESX/ESXi", true, "vide.rse.systemtype.esx", true));
        availableTargetTypes.add(new TargetType("vc", "Connection for VMware vCenter for Windows", true, "vide.rse.systemtype.vc", false));
        availableTargetTypes.add(new TargetType("vcva", "Connection for VMware vCenter for Linux", true, "vide.rse.systemtype.vcva", true));
        availableTargetTypes.add(new TargetType("linux", "Connection for Linux distributions", true, "org.eclipse.rse.systemtype.linux", true));
        availableTargetTypes.add(new TargetType("ssh", "Connection for SSH access on any platform", true, "org.eclipse.rse.systemtype.ssh", true));
        availableTargetTypes.add(new TargetType("vmssh", "Connection for VMware specific SSH only", true, "org.eclipse.rse.systemtype.ssh", true));
        availableTargetTypes.add(new TargetType("windows", "Connection for Windows", true, "org.eclipse.rse.systemtype.windows", false));
        List targetsFromExtensions = TargetTypeRegistry.getTargetsFromExtensions();
        availableTargetTypes.addAll(targetsFromExtensions);
        this.targetTypeRegistry.rebuildTargetList(availableTargetTypes);
    }

    public TargetType lookupTargetTypeByRseSystemType(String rseSystemType) {
        return this.targetTypeRegistry.lookupTargetTypeByRseSystemType(rseSystemType);
    }

    public TargetType lookupTargetTypeById(String targetTypeId) {
        return this.targetTypeRegistry.lookupTargetTypeById(targetTypeId);
    }

    public TargetManager() {
        this.loadAvailableTargetTypes();
        this.systemRegistry = RSECorePlugin.getTheSystemRegistry();
        this.systemCoreRegistry = RSECorePlugin.getTheCoreRegistry();
        this.hostListeners = new ArrayList<ITargetListener>();
    }

    public void init() {
        this.systemRegistry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
    }

    public void cleanup() {
        this.systemRegistry.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
    }

    public boolean isInitialized() {
        return RSECorePlugin.isInitComplete((int)0);
    }

    public ITarget[] getTargets() {
        IHost[] hosts = this.systemRegistry.getHosts();
        ArrayList<Target> targets = new ArrayList<Target>();
        int i = 0;
        while (i < hosts.length) {
            targets.add(TargetFactory.createTarget(this, hosts[i]));
            ++i;
        }
        return targets.toArray(new ITarget[targets.size()]);
    }

    public ITarget createTarget(String targetTypeId, String targetName, String hostNetName) {
        ITarget target = this.findTarget(targetName);
        if (target != null) {
            return target;
        }
        String defaultDescription = "New target";
        IHost host = null;
        TargetType targetType = this.lookupTargetTypeById(targetTypeId);
        if (targetType == null) {
            String msg = "Unable to get TargetType for '" + targetTypeId + "'";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        IRSESystemType systemType = this.systemCoreRegistry.getSystemTypeById(targetType.getRseSystemTypeId());
        if (systemType == null) {
            String msg = "Unable to get IRSESystemType for '" + targetType.getRseSystemTypeId() + "'";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            host = this.systemRegistry.createHost(systemType, targetName, hostNetName, defaultDescription);
        }
        catch (Exception e) {
            logger.error("Exception creating host='" + targetName + "' hostname='" + hostNetName + "'", (Throwable)e);
        }
        assert (host != null);
        target = TargetFactory.createTarget(this, host);
        assert (target != null);
        return target;
    }

    public void removeTarget(ITarget target) {
        IHost host = ((Target)target).getHost();
        this.systemRegistry.deleteHost(host);
        this.systemRegistry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object[])new IHost[]{host}, 60, null));
    }

    public ITarget findTarget(String name) {
        ISystemProfile profile = this.systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile();
        if ((name = name.trim()) != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = this.systemRegistry.getHostsByProfile(profile);
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                if (name.equals(host.getAliasName().trim()) || name.equals(host.getHostName().trim())) {
                    return TargetFactory.createTarget(this, host);
                }
                ++n2;
            }
        }
        return null;
    }

    public void addInitListener(ITargetManagerInitListener listener) {
        CheckInitJob job = new CheckInitJob("Check RSE Init", listener);
        job.setSystem(true);
        job.schedule();
    }

    public void removeInitListener(ITargetManagerInitListener listener) {
    }

    public String getId() {
        return "com.vmware.vide.rse";
    }

    public int executeCommand(ITarget target, String command, ICommandOutputListener listener) throws Exception {
        return target.executeCommand(command, listener, null);
    }

    public int executeCommand(ITarget target, String command, ICommandOutputListener listener, IProgressMonitor monitor) throws Exception {
        return target.executeCommand(command, listener, monitor);
    }

    public void executeCommandAsync(ITarget target, String command, ICommandOutputListener listener) throws Exception {
        target.executeCommandAsync(command, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetListener(ITargetListener listener) {
        List<ITargetListener> list = this.hostListeners;
        synchronized (list) {
            this.hostListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetListener(ITargetListener listener) {
        List<ITargetListener> list = this.hostListeners;
        synchronized (list) {
            this.hostListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        ITargetListener[] listeners;
        int eventType;
        boolean multiSource = false;
        if (!RSECorePlugin.isInitComplete((int)1)) {
            return;
        }
        switch (event.getType()) {
            case 51: {
                multiSource = true;
            }
            case 50: 
            case 53: {
                eventType = 1;
                break;
            }
            case 60: {
                multiSource = true;
            }
            case 55: {
                eventType = 2;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<Target> targets = new ArrayList<Target>();
        if (multiSource) {
            Object[] sources = event.getMultiSource();
            int i = 0;
            while (i < sources.length) {
                if (sources[i] instanceof IHost) {
                    targets.add(TargetFactory.createTarget(this, (IHost)sources[i]));
                }
                ++i;
            }
        } else {
            Object source = event.getSource();
            if (source instanceof IHost) {
                targets.add(TargetFactory.createTarget(this, (IHost)source));
            }
        }
        if (targets.size() == 0) {
            return;
        }
        class TargetChangedEvent
        implements ITargetChangedEvent {
            private final int type;
            private final ITarget[] targets;

            TargetChangedEvent(int type, ITarget[] targets) {
                this.type = type;
                this.targets = targets;
            }

            public ITarget[] getSources() {
                return this.targets;
            }

            public int getType() {
                return this.type;
            }
        }
        TargetChangedEvent newEvent = new TargetChangedEvent(eventType, targets.toArray(new ITarget[targets.size()]));
        List<ITargetListener> list = this.hostListeners;
        synchronized (list) {
            listeners = this.hostListeners.toArray(new ITargetListener[this.hostListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].targetChanged((ITargetChangedEvent)newEvent);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public ITarget openNewConnectionWizard() {
        IWizard realWizard;
        RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0 && (realWizard = wizard.getSelectedWizard()) instanceof RSEDefaultNewConnectionWizard) {
            IHost host = ((RSEDefaultNewConnectionWizard)realWizard).getCreatedHost();
            return TargetFactory.createTarget(this, host);
        }
        return null;
    }

    public void setBypassKeyCheck(boolean bypass) {
        vIDESshConnectorServiceManager.getInstance().setByPassKeyCheck(bypass);
    }

    public List<TargetType> getTargetTypes() {
        return this.targetTypeRegistry.getAvailableTargetTypes();
    }

    public void setSuppressPrompt(boolean prompt) {
        vIDESshConnectorServiceManager.getInstance().setSuppressPopups(true);
    }

    public boolean getSuppressPrompt() {
        return vIDESshConnectorServiceManager.getInstance().getSuppressPopups();
    }

    private class CheckInitJob
    extends Job {
        private final ITargetManagerInitListener listener;

        public CheckInitJob(String name, ITargetManagerInitListener listener) {
            super(name);
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                if (RSECorePlugin.isInitComplete((int)0)) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
            this.listener.phaseComplete(0);
            return Status.OK_STATUS;
        }
    }
}

