/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse;

import com.vmware.vide.rse.api.impl.TargetManager;
import com.vmware.vide.rse.model.ClusterElement;
import com.vmware.vide.rse.model.DataCenterElement;
import com.vmware.vide.rse.model.DataStoreElement;
import com.vmware.vide.rse.model.FolderElement;
import com.vmware.vide.rse.model.HBAElement;
import com.vmware.vide.rse.model.HostSystemElement;
import com.vmware.vide.rse.model.LunElement;
import com.vmware.vide.rse.model.PNicElement;
import com.vmware.vide.rse.model.PortGroupElement;
import com.vmware.vide.rse.model.ResourcesAdapterFactory;
import com.vmware.vide.rse.model.VSwitchElement;
import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vide.rse.subsystems.ResourcesSubSystemConfiguration;
import com.vmware.vide.rse.subsystems.ResourcesSubSystemConfigurationAdapterFactory;
import com.vmware.vide.rse.util.CertificateUtil;
import com.vmware.vide.target.api.ITargetManager;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIDERSEPlugin
extends SystemBasePlugin {
    private static final Logger logger = LoggerFactory.getLogger(VIDERSEPlugin.class);
    public static final String PLUGIN_ID = "com.vmware.vide.rse";
    public static final String ESX_PROPERTY_NAME = "ESX Properties";
    public static final String SYSTEMTYPE_ESX_ID = "vide.rse.systemtype.esx";
    public static final String SYSTEMTYPE_VMSSH_ID = "vide.rse.systemtype.ssh";
    public static final String SYSTEMTYPE_VC_ID = "vide.rse.systemtype.vc";
    public static final String SYSTEMTYPE_VCVA_ID = "vide.rse.systemtype.vcva";
    private static VIDERSEPlugin plugin;
    public static final String ICON_ID_POWERON = "action_poweron";
    public static final String ICON_ID_POWEROFF = "action_poweroff";
    public static final String ICON_ID_SUSPEND = "action_suspend4";
    public static final String ICON_ID_RESET = "action_reset";
    public static final String ICON_ID_CONSOLE = "action_console";
    public static final String ICON_ID_CONFIGURE = "action_configure";
    public static final String ICON_ID_POWER_STATE_ON = "status_poweredon";
    public static final String ICON_ID_POWER_STATE_OFF = "status_poweredoff";
    public static final String ICON_ID_POWER_STATE_SUSPENDED = "status_suspended";
    public static final String ICON_ID_VMLIST_FILTER = "vm_list_filter";
    public static final String ICON_ID_LUNLIST_FILTER = "lun_list_filter";
    public static final String ICON_ID_VSLIST_FILTER = "vs_list_filter";
    public static final String ICON_ID_HBALIST_FILTER = "hba_list_filter";
    public static final String ICON_ID_NICLIST_FILTER = "nic_list_filter";
    public static final String ICON_ID_FOLDER = "folder";
    public static final String ICON_ID_FOLDER_OPEN = "folder-open";
    public static final String ICON_ID_DATACENTER = "datacenter";
    public static final String ICON_ID_CLUSTER = "cluster";
    public static final String ICON_ID_HOST = "host";
    public static final String ICON_ID_HOST_X = "host-x";
    public static final String ICON_ID_HOST_RED = "host-red";
    public static final String RSE_BEACON_ID = "rse";
    public static final String RSE_BEACON_ACTIVITY_NEW_CONNECTION = "NewConnection";
    public static final String RSE_BEACON_ACTIVITY_OPEN_CONNECTION = "OpenConnection";
    public static final String RSE_BEACON_ACTIVITY_SYSLOG_MONITOR = "SyslogMonitor";
    public static final String RSE_BEACON_ACTIVITY_INSTALL_PACKAGE = "InstallPackage";
    public static final String RSE_BEACON_ACTIVITY_REMOTE_DISPLAY = "RemoteDisplay";
    public static final String RSE_BEACON_ACTIVITY_EXPAND_ESX_OBJECT_TYPE = "OpenESXObjectType";
    public static final String RSE_BEACON_ACTIVITY_ESX_ACTION = "ESXVmAction";
    public static final String RSE_WORKSPACE_TRUST_STORE_FILENAME = "workbench-cacerts.jks";
    public static final String RSE_WORKSPACE_TRUST_STORE_PASSPHRASE = "changeit";
    public static final String ICON_ID_MARKLOG = "action_marklog";
    private ServiceTracker tracker;
    private ITargetManager targetManager;

    public VIDERSEPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initTrustStore();
        IAdapterManager manager = Platform.getAdapterManager();
        ResourcesSubSystemConfigurationAdapterFactory sscaFactory = new ResourcesSubSystemConfigurationAdapterFactory();
        manager.registerAdapters((IAdapterFactory)sscaFactory, ResourcesSubSystemConfiguration.class);
        ResourcesAdapterFactory raFactory = new ResourcesAdapterFactory();
        manager.registerAdapters((IAdapterFactory)raFactory, VirtualMachineElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, LunElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, HBAElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, DataStoreElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, VSwitchElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, PNicElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, PortGroupElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, ClusterElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, DataCenterElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, FolderElement.class);
        manager.registerAdapters((IAdapterFactory)raFactory, HostSystemElement.class);
        this.targetManager = new TargetManager();
        this.targetManager.init();
        this.tracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.tracker.open();
        IRSESystemType type = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(SYSTEMTYPE_VMSSH_ID);
        RSEPreferencesManager.setIsSystemTypeEnabled((IRSESystemType)type, (boolean)false);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.targetManager != null) {
            this.targetManager.cleanup();
            this.targetManager = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static VIDERSEPlugin getDefault() {
        return plugin;
    }

    public static ITargetManager getTheTargetManager() {
        return VIDERSEPlugin.getDefault().getTargetManager();
    }

    public ITargetManager getTargetManager() {
        return this.targetManager;
    }

    public IProxyService getProxyService() {
        if (this.tracker != null) {
            return (IProxyService)this.tracker.getService();
        }
        return null;
    }

    protected void initializeImageRegistry() {
        String path = VIDERSEPlugin.getIconPath();
        this.putImageInRegistry(ICON_ID_POWERON, String.valueOf(path) + "vm-poweron.png");
        this.putImageInRegistry(ICON_ID_POWEROFF, String.valueOf(path) + "vm-poweroff.png");
        this.putImageInRegistry(ICON_ID_SUSPEND, String.valueOf(path) + "vm-suspend.png");
        this.putImageInRegistry(ICON_ID_RESET, String.valueOf(path) + "vm-reset.png");
        this.putImageInRegistry(ICON_ID_CONSOLE, String.valueOf(path) + "physical_computer.png");
        this.putImageInRegistry(ICON_ID_CONFIGURE, String.valueOf(path) + "ConfigureVM.png");
        this.putImageInRegistry(ICON_ID_VMLIST_FILTER, String.valueOf(path) + "main-inventory.png");
        this.putImageInRegistry(ICON_ID_LUNLIST_FILTER, String.valueOf(path) + "datastore.png");
        this.putImageInRegistry(ICON_ID_VSLIST_FILTER, String.valueOf(path) + "network.png");
        this.putImageInRegistry(ICON_ID_HBALIST_FILTER, String.valueOf(path) + "scsi.png");
        this.putImageInRegistry(ICON_ID_NICLIST_FILTER, String.valueOf(path) + "network_adapter.png");
        this.putImageInRegistry(ICON_ID_POWER_STATE_ON, String.valueOf(path) + "virtualMachine-poweredOn.png");
        this.putImageInRegistry(ICON_ID_POWER_STATE_OFF, String.valueOf(path) + "virtualMachine.png");
        this.putImageInRegistry(ICON_ID_POWER_STATE_SUSPENDED, String.valueOf(path) + "virtualMachine-suspended.png");
        this.putImageInRegistry(ICON_ID_FOLDER, String.valueOf(path) + "folder.png");
        this.putImageInRegistry(ICON_ID_FOLDER_OPEN, String.valueOf(path) + "folder-open.png");
        this.putImageInRegistry(ICON_ID_DATACENTER, String.valueOf(path) + "datacenter.png");
        this.putImageInRegistry(ICON_ID_CLUSTER, String.valueOf(path) + "compute-resource.png");
        this.putImageInRegistry(ICON_ID_HOST, String.valueOf(path) + "host.png");
        this.putImageInRegistry(ICON_ID_HOST_X, String.valueOf(path) + "host-x.png");
        this.putImageInRegistry(ICON_ID_HOST_RED, String.valueOf(path) + "host-red.png");
        this.putImageInRegistry(ICON_ID_MARKLOG, String.valueOf(path) + "label.png");
    }

    public IPropertyDescriptor[] createPropertyDescripters(String[][] propertySets) {
        ArrayList<PropertyDescriptor> propertyDescs = new ArrayList<PropertyDescriptor>();
        int i = 0;
        while (i < propertySets.length) {
            PropertyDescriptor pd = new PropertyDescriptor((Object)propertySets[i][0], propertySets[i][1]);
            pd.setDescription(propertySets[i][2]);
            propertyDescs.add(pd);
            ++i;
        }
        return (IPropertyDescriptor[])propertyDescs.toArray(new PropertyDescriptor[propertyDescs.size()]);
    }

    public String getHelpPluginId() {
        return "com.vmware.vide.core.help";
    }

    public static File getWorkbenchTrustStoreFile() {
        IPath stateLocationPath = VIDERSEPlugin.getDefault().getStateLocation();
        IPath cacertsPath = stateLocationPath.append(RSE_WORKSPACE_TRUST_STORE_FILENAME);
        return cacertsPath.toFile();
    }

    protected void initTrustStore() {
        File cacertsFile = VIDERSEPlugin.getWorkbenchTrustStoreFile();
        if (cacertsFile.isFile()) {
            CertificateUtil.setTrustStoreSystemProperties(cacertsFile.getAbsolutePath(), RSE_WORKSPACE_TRUST_STORE_PASSPHRASE);
        } else {
            logger.info("Workbench local trust store file '{}' does NOT exist.  Skipping load.", (Object)cacertsFile.getAbsolutePath());
        }
    }

    public CertificateUtil createCertificateUtil() throws Exception {
        File workspaceTrustStoreFile = VIDERSEPlugin.getWorkbenchTrustStoreFile();
        try {
            return new CertificateUtil(workspaceTrustStoreFile, RSE_WORKSPACE_TRUST_STORE_PASSPHRASE);
        }
        catch (Exception e) {
            logger.error("Exception trying to read workspace trust store file '" + workspaceTrustStoreFile.getAbsolutePath() + "'.", (Throwable)e);
            if (workspaceTrustStoreFile.isFile()) {
                workspaceTrustStoreFile.delete();
            }
            return new CertificateUtil(null, RSE_WORKSPACE_TRUST_STORE_PASSPHRASE);
        }
    }
}

