/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.peweb.PewebPanel;
import com.vmware.vide.vmwbrepository.Artifact;
import com.vmware.vide.vmwbrepository.WebServiceController;
import java.util.ArrayList;
import java.util.List;

public class DebugSymbolsPanel
extends PewebPanel {
    public static final String LINK_PREFIX = "vide:peweb/vmkdebug";
    public static final String LINK_LIST_SDK = "vide:peweb/vmkdebug/list";
    public static final String LINK_LIST_DESCRIPTION = "Debug Symbols for VMkernel Updates";
    public String LINK_REFRESH = "vide:peweb/vmkdebug/refresh";
    public static final String PANEL_UI_NAME = "Debug Symbols";
    private final String DEBUG_ARTIFACTS = "vmkdebug";
    private final String DEBUG_ARTIFACTS_OPEN = "vmkdebug/open";
    private final String WORKBENCH_TAG = "none";

    public boolean init() {
        super.init(PANEL_UI_NAME, "VMKDEBUG");
        this.setListAllLinks(LINK_LIST_SDK, LINK_LIST_DESCRIPTION);
        return true;
    }

    public boolean isLockedContent() {
        return true;
    }

    public String getHeader() {
        return LINK_LIST_DESCRIPTION;
    }

    @Override
    public String getPrefix() {
        return LINK_PREFIX;
    }

    @Override
    public void setCredentials(String loginId, String password) {
        super.setCredentials(loginId, password);
        this.setChanged();
        this.notifyObservers("");
    }

    @Override
    public String getHeaderCommands(boolean isHome) {
        StringBuffer buffer = new StringBuffer();
        if (this.isLoggedIn() && this.currentPage.startsWith(LINK_LIST_SDK)) {
            buffer.append("<a href=\"");
            buffer.append(this.LINK_REFRESH);
            buffer.append("\">");
            buffer.append("Refresh");
            buffer.append("</a>&nbsp;&nbsp;&nbsp;");
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean handleActionClick(String location) {
        if (location.startsWith(this.LINK_REFRESH)) {
            this.setCredentials(this.getUserName(), this.getPassword());
            return true;
        }
        return super.handleActionClick(location);
    }

    @Override
    protected String getHomePageFromList() {
        StringBuilder page = new StringBuilder();
        if (this.isWorking()) {
            super.addContentHeader(page, LINK_LIST_DESCRIPTION);
            page.append("<li>").append(this.getMissingInformationMessage()).append("</li>\n");
            return page.toString();
        }
        if (!this.isLoggedIn() || this.artifactsList == null || this.artifactsList.isEmpty()) {
            super.addContentHeader(page, LINK_LIST_DESCRIPTION);
            page.append("<li>").append(this.getMissingMessageFor("VMKDEBUG")).append("</li>\n");
            return page.toString();
        }
        super.addContentHeader(page, LINK_LIST_DESCRIPTION);
        String userName = this.getUserName();
        if (userName != null && this.loginError != null) {
            page.append("<li>Access was denied. Please try again.</li>\n");
        } else if (userName == null) {
            page.append("<li>You must log in to access the list of available Debug Symbol packages.</li>\n");
        } else if (this.artifactsList.size() < 1) {
            page.append("<li>There are no Debug Symbol packages available at this time.</li>\n");
        } else {
            page.append("<li>Debug Symbols packages for ");
            page.append(this.artifactsList.size());
            page.append(" builds were found. <br>");
            page.append("<a href=\"");
            page.append(this.LINK_LIST_ARTIFACTS);
            page.append("\">Click here</a> to view and download from the list of associated packages.</li>\n");
        }
        return page.toString();
    }

    @Override
    protected String getArtifactsHtml() {
        StringBuilder page = new StringBuilder();
        if (this.isWorking()) {
            super.addContentHeader(page, LINK_LIST_DESCRIPTION);
            page.append("<li>").append(this.getMissingInformationMessage()).append("</li>\n");
            return page.toString();
        }
        if (!this.isLoggedIn() || this.artifactsList == null || this.artifactsList.isEmpty()) {
            super.addContentHeader(page, LINK_LIST_DESCRIPTION);
            page.append("<li>").append(this.getMissingMessageFor("VMKDEBUG")).append("</li>\n");
            return page.toString();
        }
        if (this.connectError != null) {
            super.addContentHeaderWithSearch(page, LINK_LIST_DESCRIPTION);
            page.append("<li>").append(this.connectError).append("</li>\n");
        } else {
            int count = this.artifactsList.size();
            String header = "Debug Symbols for VMkernel Updates <span style='font-size: 70%; color: #c0c0c0;'> " + count + " available</span>";
            super.addContentHeaderWithSearch(page, header);
            for (String id : this.artifactsList.keySet()) {
                Artifact art = (Artifact)this.artifactsList.get(id);
                StringBuilder itemContent = new StringBuilder();
                String url = art.getPackageUrl();
                if (url != null && !url.isEmpty()) {
                    itemContent.append("<a href=\"" + this.getPrefix() + "/download?");
                    itemContent.append(art.getId());
                    if (WebServiceController.isTestEnvironment()) {
                        itemContent.append("\" title=\"" + url);
                    }
                    itemContent.append("\">");
                }
                itemContent.append("VMkernel build ");
                itemContent.append(art.getVersion());
                if (url != null && !url.isEmpty()) {
                    itemContent.append("</a>\n");
                }
                this.addContentItemForSearch(page, itemContent.toString());
            }
        }
        this.addContentFooterForSearch(page);
        return page.toString();
    }

    @Override
    protected List<Artifact> getArtifactsFromRepository() throws Exception {
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        if (this.webService.getUserName() != null) {
            this.webService.getArtifacts(allArtifacts, "none", "vmkdebug");
        } else {
            this.webService.getArtifacts(allArtifacts, "none", "vmkdebug/open");
        }
        for (Artifact a : allArtifacts) {
            a.setIgnoreDependencies(true);
        }
        return allArtifacts;
    }
}

