/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.wizards;

import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LogxEditingSupport
extends EditingSupport {
    private CellEditor myCellEditor;
    private int columnNum;
    private Listener myEditListener;
    private Event setDataEvent;

    public LogxEditingSupport(ColumnViewer viewer, int columnNum, Listener editListener) {
        super(viewer);
        this.columnNum = columnNum;
        this.myEditListener = editListener;
        this.setDataEvent = new Event();
        this.setDataEvent.type = 36;
        this.myCellEditor = columnNum == 0 || columnNum == 3 ? new CheckboxCellEditor(null, 40) : (columnNum == 2 ? new TextCellEditor((Composite)((TableViewer)viewer).getTable()) : new TextCellEditor((Composite)((TableViewer)viewer).getTable(), 8));
    }

    public LogxEditingSupport(ColumnViewer viewer, int columnNum) {
        this(viewer, columnNum, null);
    }

    protected void setValue(Object tableItem, Object newValue) {
        LogxFile lxFile = (LogxFile)tableItem;
        if (this.columnNum == 0) {
            lxFile.setCreateThisFile(((Boolean)newValue).booleanValue());
        } else if (this.columnNum == 2) {
            lxFile.setLogxFileName(newValue.toString());
        } else if (this.columnNum == 3) {
            lxFile.setOpenEditor(((Boolean)newValue).booleanValue());
        }
        this.getViewer().update(tableItem, null);
        if (this.myEditListener != null) {
            this.myEditListener.handleEvent(this.setDataEvent);
        }
    }

    protected Object getValue(Object tableItem) {
        LogxFile lxFile = (LogxFile)tableItem;
        if (this.columnNum == 0) {
            return lxFile.isCreateThisFile();
        }
        if (this.columnNum == 1) {
            return lxFile.toSummaryString();
        }
        if (this.columnNum == 2) {
            return lxFile.getLogxFileName();
        }
        if (this.columnNum == 3) {
            return lxFile.isOpenEditor();
        }
        return null;
    }

    protected boolean canEdit(Object obj) {
        if (this.columnNum == 0) {
            return true;
        }
        return ((LogxFile)obj).isCreateThisFile();
    }

    protected CellEditor getCellEditor(Object obj) {
        return this.myCellEditor;
    }
}

