/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.wizards;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileManager;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.wizards.LogBrowserNewWizard;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFileAction;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBNewWizardPathPage
extends WizardPage {
    private static final Logger logger = LoggerFactory.getLogger(LBNewWizardPathPage.class);
    private static final String PARENT_DIRECTORY = "Parent directory:";
    private String chosenSrcHost;
    private String chosenLogFormat;
    private Label lblInstructions;
    private Combo cboParentDir;
    private Text txtFilePatterns;
    private Button btnRSEBrowse;
    private Button btnShowAllFiles;
    private LogBrowserNewWizard myParentWizard;
    private LogxFile myLxFile;
    private boolean allowMultiSelect;
    private Pattern myPattern;
    private String tgzFilepath;
    private Link savePreferenceLink;
    private String[] knownDirs = null;
    public static final String REMOTE_LIST_FAILED_TITLE = "Failed to acquire file list";
    public static final String REMOTE_LIST_FAILED_MSG = "Error: unable to get a list of matching files from the specified host. Check the host connection. ";
    public static final String DEFAULT_FILE_PATTERNS_MSG = "(default file patterns)";

    public LBNewWizardPathPage(ISelection selection) {
        super("LogBrowserNewWizardPathPage");
        this.setTitle("Log File Path Selection");
        this.setDescription("This wizard creates one or more new vLogBrowser configuration files (.logx files).");
        this.setMessage("Click \"Next\" to retrieve log files matching the specified file patterns in the specified directory, or click browse to modify these values.");
        this.setImageDescriptor(LogBrowserUiPlugin.getImageDescriptor("/icons/wizard.png"));
        this.allowMultiSelect = true;
    }

    public void createControl(Composite parent) {
        this.knownDirs = null;
        this.myParentWizard = (LogBrowserNewWizard)this.getWizard();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.lblInstructions = new Label(container, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.lblInstructions.setLayoutData((Object)gd);
        Label lblParentDir = new Label(container, 0);
        lblParentDir.setText("&Parent directory:");
        lblParentDir.setToolTipText("The parent directory contains the log files that will be analyzed by vLogBrowser. Only one parent directory can be selected.  The drop down list may contain directories known to be used for the selected  format.");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        lblParentDir.setLayoutData((Object)gd);
        this.cboParentDir = new Combo(container, 4);
        this.cboParentDir.setToolTipText("Path to a directory to scan for matching log files");
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 311;
        this.cboParentDir.setLayoutData((Object)gd);
        this.btnRSEBrowse = new Button(container, 8);
        this.btnRSEBrowse.setText("&Browse...");
        this.btnRSEBrowse.setData("name", (Object)"btnRSEBrowse");
        this.btnRSEBrowse.setToolTipText("View the file system tree on the chosen source host. From this view, a parent directory can be selected that contains log files matching the given file pattern. Alternatively, this view also allows one or more individual log files within a single parent directory to be selected.");
        gd = new GridData(2, 2, false, false);
        gd.verticalSpan = 1;
        gd.widthHint = 100;
        this.btnRSEBrowse.setLayoutData((Object)gd);
        this.btnRSEBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LBNewWizardPathPage.this.handleRSEBrowseButton();
            }
        });
        this.btnShowAllFiles = new Button(container, 32);
        this.btnShowAllFiles.setText("&Show all files");
        this.btnShowAllFiles.setToolTipText("For advanced users only: check to show all files,  including those not matched by the file pattern. Uncheck to only show files that match the file pattern.");
        this.btnShowAllFiles.setSelection(false);
        this.btnShowAllFiles.setVisible(true);
        gd = new GridData(2, 2, false, false);
        gd.verticalSpan = 1;
        this.btnShowAllFiles.setLayoutData((Object)gd);
        Label lblFilePattern = new Label(container, 0);
        lblFilePattern.setText("&File or pattern:");
        lblFilePattern.setToolTipText("If this field is set to a regular expression, all files found in the parent directory that match that expression will be loaded. Alternatively, individual log files within the parent directory can be chosen. If individual log files are selected, regular expression matching will not be used to find log files.");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        lblFilePattern.setLayoutData((Object)gd);
        this.txtFilePatterns = new Text(container, 2052);
        this.txtFilePatterns.setData("name", (Object)"txtFilePatterns");
        this.txtFilePatterns.setEditable(false);
        this.txtFilePatterns.setBackground(Display.getCurrent().getSystemColor(19));
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 300;
        this.txtFilePatterns.setLayoutData((Object)gd);
        this.savePreferenceLink = new Link(container, 0);
        this.savePreferenceLink.setEnabled(false);
        this.savePreferenceLink.setText("<a>Save in preferences</a>");
        this.savePreferenceLink.setToolTipText("Save log directory on Eclipse Preferences page");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        this.savePreferenceLink.setLayoutData((Object)gd);
        final LogBrowserNewWizard localParent = this.myParentWizard;
        this.savePreferenceLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    ICommandService comandService = (ICommandService)workbench.getService(ICommandService.class);
                    ParameterizedCommand command = comandService.deserialize("org.eclipse.ui.window.preferences(preferencePageId=org.eclipse.ui.preferencePages.LinkedResources)");
                    IHandlerService hs = (IHandlerService)workbench.getService(IHandlerService.class);
                    workbench.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IPathVariableManager pathManager = workspace.getPathVariableManager();
                            String formatName = localParent.getSelectedLogFormatName();
                            String name = "LOGBROWSER_PREF_DIR_" + formatName.toUpperCase();
                            name = name.replaceAll("\\W", "_");
                            Path value = new Path(LBNewWizardPathPage.this.cboParentDir.getText());
                            try {
                                if (pathManager.validateName(name).isOK() && pathManager.validateValue((IPath)value).isOK()) {
                                    pathManager.setValue(name, (IPath)value);
                                } else {
                                    logger.error("Path name should be valid and absolute");
                                }
                            }
                            catch (CoreException e) {
                                logger.error("Unable to save log directory on Eclipse preference page", (Throwable)e);
                            }
                        }
                    });
                    hs.executeCommand(command, null);
                }
                catch (Exception exception) {}
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Button btnLoadDefaults = new Button(container, 8);
        btnLoadDefaults.setData("name", (Object)"btnLoadDefaults");
        btnLoadDefaults.setText("&Restore Defaults");
        btnLoadDefaults.setToolTipText("Use the default parent directory and file patterns for the selected host and log format (note: the default may be an empty value)");
        gd = new GridData(1, 2, false, false);
        gd.horizontalSpan = 2;
        btnLoadDefaults.setLayoutData((Object)gd);
        btnLoadDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LBNewWizardPathPage.this.initializePage();
                LBNewWizardPathPage.this.updateStatus(null);
            }
        });
        this.updateStatus(null);
        this.setControl((Control)container);
    }

    private void handleRSEBrowseButton() {
        final SystemSelectRemoteFileAction action = new SystemSelectRemoteFileAction(this.getShell());
        action.setShowNewConnectionPrompt(false);
        action.setShowPropertySheet(true, false);
        action.setMultipleSelectionMode(this.allowMultiSelect);
        action.setDialogTitle("Browse for a directory, or browse for file(s)");
        action.setMessage("You are browsing host '" + this.chosenSrcHost + "' for files that match" + " '" + this.chosenLogFormat + "'. Select a single directory that contains matching" + " files, or select one or more matching files within a single directory.");
        final String destValue = String.valueOf(this.chosenSrcHost) + ":" + this.cboParentDir.getText() + "*";
        final StringBuffer pathSep = new StringBuffer();
        final IHost host = Utilities.parseForSystemConnection((String)destValue);
        action.setHost(host);
        final String recentPath = this.cboParentDir.getText();
        IRunnableWithProgress getFileListRunner = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                String name = "Checking log files on {0}...";
                name = MessageFormat.format(name, LBNewWizardPathPage.this.chosenSrcHost);
                monitor.beginTask(name, 2);
                try {
                    try {
                        String selection = Utilities.parseForPath((String)destValue);
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
                        char sep = fss.getSeparatorChar();
                        if (sep != '/') {
                            selection = selection.replace('/', sep);
                        }
                        IRemoteFile path = fss.getRemoteFileObject(selection, monitor);
                        pathSep.append(String.valueOf(sep));
                        if (!(path != null || (path = fss.getRemoteFileObject(recentPath.length() == 0 ? pathSep.toString() : recentPath, monitor)) != null && path.exists())) {
                            path = fss.getRemoteFileObject("/", monitor);
                        }
                        action.setPreSelection(path);
                    }
                    catch (SystemMessageException ex) {
                        throw new InvocationTargetException(ex, ex.getMessage());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, getFileListRunner);
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)REMOTE_LIST_FAILED_TITLE, (String)(REMOTE_LIST_FAILED_MSG + ex.getMessage()));
            ex.printStackTrace();
            return;
        }
        if (!this.btnShowAllFiles.getSelection()) {
            String regexPatternStr = this.chosenLogFormat.equals("[VMware Log Bundle]") ? "(.+\\.tgz$)|(.+\\.zip$)" : this.myLxFile.getSystemType().getFileRegex();
            this.myPattern = Pattern.compile(regexPatternStr);
            class MySAVF
            extends SystemActionViewerFilter {
                MySAVF() {
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!super.select(viewer, parentElement, element)) {
                        return false;
                    }
                    if (element instanceof IRemoteFile && !((IRemoteFile)element).isDirectory()) {
                        IRemoteFile myRemoteFile = (IRemoteFile)element;
                        Matcher myMatcher = LBNewWizardPathPage.this.myPattern.matcher(myRemoteFile.getName());
                        boolean found = myMatcher.find();
                        return found;
                    }
                    return true;
                }
            }
            action.setCustomViewerFilter((SystemActionViewerFilter)new MySAVF());
        }
        action.run();
        String filePatterns = "";
        String rseParentDir = "";
        if (this.allowMultiSelect) {
            Object[] selectedFileObjs = action.getSelectedObjects();
            if (selectedFileObjs != null && selectedFileObjs.length > 0) {
                Object[] objectArray = selectedFileObjs;
                int n = selectedFileObjs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedFileObj = objectArray[n2];
                    IRemoteFile selectedFile = (IRemoteFile)selectedFileObj;
                    UniFilePlus ufp = new UniFilePlus(selectedFile);
                    if (ufp.isFile()) {
                        filePatterns = String.valueOf(filePatterns) + (filePatterns.length() > 0 ? ";" : "");
                        filePatterns = String.valueOf(filePatterns) + ufp.getName();
                        rseParentDir = ufp.getParent();
                    } else {
                        rseParentDir = ufp.getPath();
                    }
                    ++n2;
                }
            }
        } else {
            IRemoteFile fullPath = action.getSelectedFile();
            if (fullPath != null) {
                UniFilePlus ufp = new UniFilePlus(fullPath);
                if (ufp.isDirectory()) {
                    rseParentDir = ufp.getPath();
                } else {
                    rseParentDir = ufp.getParent();
                    filePatterns = ufp.getName();
                }
            }
        }
        if (filePatterns.length() > 0) {
            this.txtFilePatterns.setText(filePatterns);
        }
        if (rseParentDir != null && rseParentDir.length() > 0) {
            String pathSepStr = pathSep.toString();
            String dir = String.valueOf(rseParentDir) + (!rseParentDir.endsWith(pathSepStr) ? pathSepStr : "");
            this.setParentDirText(dir, null);
            ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
            manager.setRecentHostDir(this.chosenSrcHost, dir);
        }
        this.tgzFilepath = this.chosenLogFormat.equals("[VMware Log Bundle]") ? String.valueOf(this.cboParentDir.getText()) + filePatterns : null;
        this.updateStatus(null);
    }

    private void setParentDirText(String text, String[] dropdownItems) {
        if (dropdownItems != null) {
            this.cboParentDir.setItems(dropdownItems);
        }
        String[] currentItems = this.cboParentDir.getItems();
        int textIndex = 0;
        while (textIndex < currentItems.length) {
            if (text.equals(currentItems[textIndex])) break;
            ++textIndex;
        }
        if (textIndex == currentItems.length) {
            currentItems = Arrays.copyOf(currentItems, currentItems.length + 1);
            textIndex = currentItems.length - 1;
            currentItems[textIndex] = text;
        }
        this.cboParentDir.setItems(currentItems);
        this.cboParentDir.setText(text);
    }

    private void rewriteLblInstructions() {
        this.lblInstructions.setToolTipText("");
        String chosenLogFormatStr = "";
        chosenLogFormatStr = !this.chosenLogFormat.equals("[Standard Log Collection]") && !this.chosenLogFormat.equals("[VMware Log Bundle]") ? "\"" + this.chosenLogFormat + "\" format" : this.chosenLogFormat;
        String lblStr = "You have chosen the " + chosenLogFormatStr + " on the \"" + this.chosenSrcHost + "\" host.";
        this.lblInstructions.setText(lblStr);
        this.lblInstructions.pack(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.chosenSrcHost == null || this.chosenLogFormat == null || !this.chosenSrcHost.equals(this.myParentWizard.getChosenSrcHost()) || !this.chosenLogFormat.equals(this.myParentWizard.getSelectedLogFormatName())) {
                this.chosenSrcHost = this.myParentWizard.getChosenSrcHost();
                this.chosenLogFormat = this.myParentWizard.getSelectedLogFormatName();
                this.myLxFile = this.myParentWizard.getSelectedLogFormat();
                this.initializePage();
                this.rewriteLblInstructions();
            }
            this.updateStatus(null);
        }
        super.setVisible(visible);
    }

    private void initializePage() {
        ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
        String recentPath = manager.getRecentHostDir(this.chosenSrcHost);
        String logFormatName = this.myParentWizard.getSelectedLogFormatName();
        this.cboParentDir.setToolTipText("");
        this.txtFilePatterns.setToolTipText("");
        if (this.chosenLogFormat.equals("[Standard Log Collection]")) {
            this.txtFilePatterns.setText(DEFAULT_FILE_PATTERNS_MSG);
            this.btnRSEBrowse.setEnabled(false);
            this.btnShowAllFiles.setSelection(false);
            this.btnShowAllFiles.setEnabled(false);
            this.allowMultiSelect = false;
            String dir = recentPath.length() != 0 ? recentPath : this.findLinkedResource(logFormatName);
            this.setParentDirText(dir, new String[]{dir});
        } else if (this.chosenLogFormat.equals("[VMware Log Bundle]")) {
            this.txtFilePatterns.setText("");
            this.btnRSEBrowse.setEnabled(true);
            this.btnShowAllFiles.setSelection(false);
            this.btnShowAllFiles.setEnabled(false);
            this.allowMultiSelect = false;
            String dir = recentPath.length() != 0 ? recentPath : this.findLinkedResource(logFormatName);
            this.setParentDirText(dir, new String[]{dir});
        } else if (this.myParentWizard.getSrcSupportSsh()) {
            this.btnRSEBrowse.setEnabled(true);
            this.btnShowAllFiles.setEnabled(true);
            this.btnShowAllFiles.setSelection(false);
            this.txtFilePatterns.setText("");
            try {
                this.txtFilePatterns.setText("(Regular Expression: " + this.myLxFile.getSystemType().getFileRegex() + ")");
            }
            catch (Exception exception) {
                this.btnShowAllFiles.setSelection(true);
            }
            String dir = this.myLxFile.getSystemType().getDir();
            this.knownDirs = dir.split("\\|");
            if (this.knownDirs == null || this.knownDirs.length == 0) {
                this.knownDirs = new String[]{dir};
            }
            this.setParentDirText(this.knownDirs[0], this.knownDirs);
            String localPath = this.findLinkedResource(logFormatName);
            if (!localPath.isEmpty()) {
                this.setParentDirText(localPath, null);
            }
            this.allowMultiSelect = true;
        } else {
            this.setParentDirText("", null);
            this.btnRSEBrowse.setEnabled(true);
            this.btnShowAllFiles.setEnabled(true);
            this.btnShowAllFiles.setSelection(false);
            try {
                this.txtFilePatterns.setText("(Regular Expression: " + this.myLxFile.getSystemType().getFileRegex() + ")");
            }
            catch (Exception exception) {
                this.btnShowAllFiles.setSelection(true);
            }
            try {
                String dir;
                if (LogFileManager.isLocalHost((String)this.chosenSrcHost)) {
                    dir = recentPath;
                } else {
                    dir = this.myLxFile.getSystemType().getDir();
                    this.knownDirs = dir.split("\\|");
                    if (this.knownDirs == null || this.knownDirs.length == 0) {
                        this.knownDirs = new String[]{dir};
                    }
                    dir = this.knownDirs[0];
                }
                this.setParentDirText(dir, this.knownDirs);
            }
            catch (Exception exception) {}
            String localPath = this.findLinkedResource(logFormatName);
            if (!localPath.isEmpty()) {
                this.setParentDirText(localPath, this.knownDirs);
            }
            this.allowMultiSelect = true;
        }
    }

    private String findLinkedResource(String logFormatName) {
        String name;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathManager = workspace.getPathVariableManager();
        IPath value = pathManager.getValue(name = "LOGBROWSER_PREF_DIR_" + (logFormatName = logFormatName.replaceAll("\\W", "_")).toUpperCase());
        if (value != null) {
            return value.toOSString();
        }
        return "";
    }

    private void updateStatus(String errorMessage) {
        if (this.chosenLogFormat == null || this.chosenLogFormat.isEmpty()) {
            this.setPageComplete(false);
            return;
        }
        if (this.chosenLogFormat.equals("[Standard Log Collection]")) {
            if (!this.txtFilePatterns.getText().equals(DEFAULT_FILE_PATTERNS_MSG)) {
                errorMessage = "Specific directories and files cannot be chosen. Only the standard set of logs for the chosen host will be retrieved.";
            }
        } else if (this.chosenLogFormat.equals("[VMware Log Bundle]")) {
            if (this.cboParentDir.getText().length() == 0 || this.txtFilePatterns.getText().length() == 0) {
                errorMessage = "Use the \"Browse...\" button to select a supported log bundle file with a \".tgz\" or \".zip\" extension.";
            } else if (this.tgzFilepath == null) {
                errorMessage = "The archive chosen was not recognized as a valid log bundle archive  created by a VMware product. Please choose a valid log bundle.";
            }
        } else if (this.txtFilePatterns.getText().length() == 0) {
            errorMessage = "Use the \"Browse...\" button to locate a log file or file(s).";
        } else if (this.cboParentDir.getText().length() == 0) {
            errorMessage = "Use the \"Browse...\" button to select a parent directory that contains files matching the specified file pattern.";
        }
        errorMessage = errorMessage == null ? this.validateLogFilesInsideParentDir() : errorMessage;
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.savePreferenceLink.setEnabled(true);
        } else {
            this.savePreferenceLink.setEnabled(false);
        }
        this.setPageComplete(errorMessage == null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateLogFilesInsideParentDir() {
        String errorMessage = null;
        String regexPatternStr = this.chosenLogFormat.equals("[VMware Log Bundle]") ? "(.+\\.tgz$)|(.+\\.zip$)" : this.myLxFile.getSystemType().getFileRegex();
        Pattern pattern = Pattern.compile(regexPatternStr);
        String hostname = this.myParentWizard.getChosenSrcHost();
        try {
            ITarget target = LogFileUtils.getTarget((String)hostname);
            if (!target.isConnected()) {
                target.connect(null);
            }
            String[] directories = this.cboParentDir.getItems();
            int i = directories.length - 1;
            while (true) {
                if (i < 0) {
                    this.cboParentDir.setText("");
                    return "Use the \"Browse...\" button to select a parent directory that contains files matching the specified file pattern.";
                }
                try {
                    String dir = directories[i];
                    ITargetFile targetFile = target.getTargetFile(dir, null);
                    ITargetFile[] fileList = targetFile.listFiles(null);
                    int j = 0;
                    while (j < fileList.length) {
                        ITargetFile f = fileList[j];
                        String fileName = f.getCanonicalPath();
                        Matcher matcher = pattern.matcher(fileName);
                        if (matcher.find()) {
                            this.setParentDirText(dir, null);
                            return null;
                        }
                        ++j;
                    }
                }
                catch (Exception exception) {}
                --i;
            }
        }
        catch (Exception exception) {
            return "Unable to connect to the remote host " + hostname;
        }
    }

    protected String getParentDir() {
        if (this.cboParentDir != null && !this.cboParentDir.isDisposed()) {
            return this.cboParentDir.getText();
        }
        return "";
    }

    protected String getFilePatterns() {
        if (this.txtFilePatterns != null && !this.txtFilePatterns.isDisposed()) {
            return this.txtFilePatterns.getText();
        }
        return "";
    }

    protected String getTGZFilepath() {
        return this.tgzFilepath;
    }

    public boolean isPageComplete() {
        String selectedFormatName = this.myParentWizard.getSelectedLogFormatName();
        if (selectedFormatName != null && selectedFormatName.equals("[Standard Log Collection]")) {
            return true;
        }
        return super.isPageComplete();
    }
}

