/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.tableviewer;

import com.vmware.vide.vlogbrowser.ui.tableviewer.IParserJobListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class ParserJobListener
extends JobChangeAdapter {
    private ParserJobState jobState = ParserJobState.INITIAL;
    public transient List<IParserJobListener> listParserJobListener = new LinkedList<IParserJobListener>();
    private List<Job> listCurrentJobs = Collections.synchronizedList(new ArrayList());
    private List<Object> listEditors = Collections.synchronizedList(new ArrayList());

    public void scheduled(IJobChangeEvent event) {
        this.jobState = ParserJobState.SCHEDULED;
        for (IParserJobListener listener : this.listParserJobListener) {
            listener.parserScheduled();
        }
    }

    public void running(IJobChangeEvent event) {
        this.jobState = ParserJobState.RUNNING;
        for (IParserJobListener listener : this.listParserJobListener) {
            listener.parserRunning();
        }
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        this.listCurrentJobs.remove(job);
        if (this.listCurrentJobs.isEmpty()) {
            if (event.getResult() == Status.CANCEL_STATUS) {
                this.jobState = ParserJobState.CANCELLED;
            } else if (event.getResult() == Status.OK_STATUS) {
                this.jobState = ParserJobState.DONE;
            }
            for (IParserJobListener listener : this.listParserJobListener) {
                listener.parserDone(this.listEditors);
            }
            this.listEditors.removeAll(this.listEditors);
        }
    }

    public ParserJobState getJobState() {
        return this.jobState;
    }

    public synchronized void addListener(IParserJobListener listener) {
        this.listParserJobListener.add(listener);
    }

    public synchronized void removeListener(IParserJobListener listener) {
        this.listParserJobListener.remove(listener);
    }

    public void addEditorJob(Object editor, Job job) {
        this.listCurrentJobs.add(job);
        this.listEditors.add(editor);
    }

    public static enum ParserJobState {
        INITIAL,
        SCHEDULED,
        RUNNING,
        DONE,
        CANCELLED;

    }
}

