/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.syslog;

import java.net.InetAddress;
import java.util.Date;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SyslogMessage
implements IPropertySource {
    private final String[] SEVERITY = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};
    private final String[] FACILITY = new String[]{"Kernel", "User", "Mail", "System", "Security", "Syslog", "Printer", "Network", "UUCP", "Clock", "Security", "FTP", "NTP", "LogAudit", "LogAlert", "Clock", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7"};
    private int facility;
    private int severity;
    private String timestamp;
    private String hostname;
    private String tag;
    private String content;
    private static int fgCounter;
    private int number;
    private Date receivedDate;
    private InetAddress address;
    private int port;
    private String msg;
    protected static final PropertyDescriptor[] propertyDescriptors;

    static {
        propertyDescriptors = new PropertyDescriptor[10];
    }

    public SyslogMessage(int facility, int severity, String timestamp, String hostname, String tag, String content, InetAddress address, int port, String msg) {
        this.facility = facility;
        this.severity = severity;
        this.timestamp = timestamp;
        this.hostname = hostname;
        this.tag = tag;
        this.content = content;
        this.address = address;
        this.port = port;
        this.number = fgCounter++;
        this.receivedDate = new Date();
        this.msg = msg;
    }

    public int getFacility() {
        return this.facility;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityText() {
        String result = "unknown";
        if (this.severity >= 0 && this.severity < this.SEVERITY.length) {
            result = this.SEVERITY[this.severity];
        }
        return result;
    }

    public String getFacilityText() {
        String result = "unknown";
        if (this.facility >= 0 && this.facility < this.FACILITY.length) {
            result = this.FACILITY[this.facility];
        }
        return result;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getTag() {
        return this.tag;
    }

    public String getContent() {
        return this.content;
    }

    public int getNumber() {
        return this.number;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getMsg() {
        return this.msg;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        SyslogMessage.propertyDescriptors[0] = new PropertyDescriptor((Object)new String("Facility"), "Facility");
        propertyDescriptors[0].setCategory("Syslog");
        SyslogMessage.propertyDescriptors[1] = new PropertyDescriptor((Object)new String("Severity"), "Severity");
        propertyDescriptors[1].setCategory("Syslog");
        SyslogMessage.propertyDescriptors[2] = new PropertyDescriptor((Object)new String("Timestamp"), "Timestamp");
        propertyDescriptors[2].setCategory("Syslog");
        SyslogMessage.propertyDescriptors[3] = new PropertyDescriptor((Object)new String("Hostname"), "Hostname");
        propertyDescriptors[3].setCategory("Syslog");
        SyslogMessage.propertyDescriptors[4] = new PropertyDescriptor((Object)new String("Content"), "Content");
        propertyDescriptors[4].setCategory("Syslog");
        SyslogMessage.propertyDescriptors[5] = new PropertyDescriptor((Object)new String("Number"), "Number");
        propertyDescriptors[5].setCategory("Information");
        SyslogMessage.propertyDescriptors[6] = new PropertyDescriptor((Object)new String("ReceiveDate"), "ReceiveDate");
        propertyDescriptors[6].setCategory("Information");
        SyslogMessage.propertyDescriptors[7] = new PropertyDescriptor((Object)new String("Address"), "Address");
        propertyDescriptors[7].setCategory("Information");
        SyslogMessage.propertyDescriptors[8] = new PropertyDescriptor((Object)new String("Port"), "Port");
        propertyDescriptors[8].setCategory("Information");
        SyslogMessage.propertyDescriptors[9] = new PropertyDescriptor((Object)new String("ComputerHostname"), "ComputerHostname");
        propertyDescriptors[9].setCategory("Information");
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        String retVal;
        if (((String)id).equals("Facility")) {
            retVal = String.valueOf(Integer.toString(this.getFacility())) + " [" + this.getFacilityText() + "]";
        } else if (((String)id).equals("Severity")) {
            retVal = String.valueOf(Integer.toString(this.getSeverity())) + " [" + this.getSeverityText() + "]";
        } else if (((String)id).equals("Timestamp")) {
            retVal = this.getTimestamp();
        } else if (((String)id).equals("Hostname")) {
            retVal = this.getHostname();
        } else if (((String)id).equals("Content")) {
            retVal = this.getContent().toString();
        } else if (((String)id).equals("Number")) {
            retVal = Integer.toString(this.getNumber());
        } else if (((String)id).equals("ReceiveDate")) {
            retVal = this.getReceivedDate().toString();
        } else if (((String)id).equals("Address")) {
            retVal = this.getAddress().getHostAddress();
        } else if (((String)id).equals("Port")) {
            retVal = Integer.toString(this.getPort());
        } else if (((String)id).equals("ComputerHostname")) {
            retVal = this.getHostname();
        } else {
            return null;
        }
        return retVal;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getEditableValue() {
        return null;
    }
}

