/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.syslog;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.ui.syslog.SyslogMessage;
import java.io.IOException;
import java.util.Date;

public class SyslogItem
extends LogItem {
    private SyslogMessage fMessage;
    private String fText;
    private static final int COLUMN_INDEX = 0;
    private static final int COLUMN_DATE = 1;
    private static final int COLUMN_PRIORITY = 2;
    private static final int COLUMN_SOURCE = 3;
    private static final int COLUMN_HOSTNAME = 4;
    private static final int COLUMN_MESSAGE = 5;

    public SyslogItem(long logIndexNum, SyslogMessage msg, String messageText) {
        super(true, 0L, 0, new Date(), logIndexNum, 0);
        this.fMessage = msg;
        this.fText = messageText;
    }

    public String getLogExtra(LogFormat myLogFormat) throws IOException {
        return "";
    }

    public Object getLogField(int column, LogFormat myLogFormat) throws IOException {
        if (column == 0 || column == 1) {
            return super.getLogField(column, myLogFormat);
        }
        if (column == 2 && this.fMessage != null) {
            return String.valueOf(this.fMessage.getFacilityText()) + "." + this.fMessage.getSeverityText();
        }
        if (column == 3 && this.fMessage != null) {
            return this.fMessage.getTag();
        }
        if (column == 4 && this.fMessage != null) {
            return this.fMessage.getHostname();
        }
        if (column == 5) {
            String msg = this.fMessage == null ? this.fText : this.fMessage.getContent();
            return msg;
        }
        return "";
    }

    public RAFile getSrcFile(LogFormat myLogFormat) {
        return null;
    }

    public byte[] getLogEntryBytes(LogFormat myLogFormat) throws IOException {
        String msg = this.fMessage == null ? this.fText : this.fMessage.getMsg();
        byte[] bytes = msg.getBytes();
        return bytes;
    }
}

