/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.syslog;

import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.syslog.ISyslogListener;
import com.vmware.vide.vlogbrowser.ui.syslog.SyslogCollector;
import com.vmware.vide.vlogbrowser.ui.syslog.SyslogItem;
import com.vmware.vide.vlogbrowser.ui.syslog.SyslogMessage;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.UIElement;

public class SyslogControlHandler
extends AbstractHandler
implements IElementUpdater {
    private SyslogCollector fSyslogCollector;
    private int fSyslogEventCounter;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LogBrowserEditor syslogEditor = null;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchPage page = part.getSite().getPage();
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            String title;
            IEditorReference ref = editors[i];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null && editor instanceof LogBrowserEditor && (title = editor.getTitle()).equals("syslog.logx") && this.fSyslogCollector != null) {
                syslogEditor = (LogBrowserEditor)editor;
                this.stopSyslog(syslogEditor);
                this.updateCommandText(event, syslogEditor);
                break;
            }
            ++i;
        }
        if (syslogEditor == null) {
            syslogEditor = this.startSyslog(page);
            this.updateCommandText(event, syslogEditor);
        }
        return null;
    }

    private LogBrowserEditor startSyslog(IWorkbenchPage page) {
        LogBrowserEditor syslogEditor = null;
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IProject iprj = projects[0];
            IFile file = iprj.getFile("syslog.logx");
            if (!file.exists()) {
                ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
                LogxFile[] logFormats = manager.getLogFormatsByHosttype("syslog", "", false);
                String path = logFormats[0].getTemplateFilePath();
                File syslogFormat = new File(path);
                FileInputStream stream = new FileInputStream(syslogFormat);
                file.create((InputStream)stream, true, null);
            }
            syslogEditor = (LogBrowserEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (syslogEditor != null) {
            LogTableViewer viewer = syslogEditor.getLogTableViewer();
            final LogWorker logWorker = viewer.getLogWorker();
            this.fSyslogEventCounter = 0;
            this.fSyslogCollector = new SyslogCollector();
            this.fSyslogCollector.addListener(new ISyslogListener(){

                @Override
                public void messageReceived(SyslogMessage msg, String text) {
                    SyslogControlHandler syslogControlHandler = SyslogControlHandler.this;
                    int n = syslogControlHandler.fSyslogEventCounter;
                    syslogControlHandler.fSyslogEventCounter = n + 1;
                    SyslogItem item = new SyslogItem(n, msg, text);
                    logWorker.getFilterList().add((Object)item);
                }
            });
            try {
                this.fSyslogCollector.start2();
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Syslog", (String)ex.getMessage());
                this.fSyslogCollector = null;
            }
        }
        return syslogEditor;
    }

    private void stopSyslog(LogBrowserEditor editor) {
        this.fSyslogCollector.setJobFinished(true);
        this.fSyslogCollector = null;
    }

    private void updateCommandText(ExecutionEvent event, LogBrowserEditor syslogEditor) {
        ICommandService serv = (ICommandService)syslogEditor.getSite().getService(ICommandService.class);
        String cmdId = event.getCommand().getId();
        serv.refreshElements(cmdId, null);
    }

    public void updateElement(UIElement element, Map parameters) {
        String newActionText = this.fSyslogCollector == null ? "Start Syslog" : "Stop Syslog";
        element.setText(newActionText);
        element.setTooltip(newActionText);
    }
}

