/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.runners;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LogFilterJob
extends Job {
    private LogTableViewer viewer;
    private LogFilter filter;

    public LogFilterJob(LogTableViewer viewer, LogFilter filter, String title) {
        super(title);
        this.viewer = viewer;
        this.filter = filter;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.viewer.updateFilter(monitor, this.filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("While trying to perform filter operation '" + this.getFilterMessage() + "' an error occurred: " + e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private String getFilterMessage() {
        String filterMsg = "";
        if (!this.filter.isFilterEnabled()) {
            filterMsg = "Unfiltering...";
        } else {
            filterMsg = "Filtering ";
            if (!this.filter.isJustAKeyword()) {
                filterMsg = String.valueOf(filterMsg) + "on a filter expression named '" + this.filter.getName() + "'";
            } else {
                try {
                    filterMsg = String.valueOf(filterMsg) + "on keyword '" + this.filter.getFirstKeyword() + "'";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int additionalFilterLines = this.filter.getNumSurroundingLines();
            if (additionalFilterLines > 0) {
                filterMsg = String.valueOf(filterMsg) + " with " + additionalFilterLines + " surrounding line" + (additionalFilterLines == 1 ? "" : "s");
            }
        }
        return filterMsg;
    }

    private void showError(final String message) {
        Display display = this.viewer.getPageComposite().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)LogFilterJob.this.viewer.getPageComposite().getShell(), (String)"Error", (String)message);
            }
        });
    }
}

