/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.handlers;

import com.vmware.vide.utils.resource.ResourceUtils;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.script.recorder.ScriptRecorderManager;
import com.vmware.vide.vlogbrowser.ui.EditorUtils;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingToggleHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(RecordingToggleHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Shell parentShell = null;
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor != null) {
                parentShell = editor.getSite().getShell();
            } else {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                parentShell = window.getShell();
            }
            Command command = event.getCommand();
            boolean isRecording = RecordingToggleHandler.getCommandState(command);
            Object trigger = event.getTrigger();
            if (isRecording) {
                logger.info("stopping log browser script recording");
                String scriptFileAbsolutePath = ScriptRecorderManager.getInstance().stopRecording(null);
                RecordingToggleHandler.setCommandState(trigger, command, !isRecording);
                ResourceUtils.refreshFileParent((String)scriptFileAbsolutePath, null);
                String message = "Recording stopped.  Script is available at " + scriptFileAbsolutePath + ".";
                MessageDialog.openInformation((Shell)parentShell, (String)"Log Browser script recording", (String)message);
            } else {
                logger.info("starting log browser script recording");
                ILogBrowserManager lbManager = LogBrowserPlugin.getDefault().getLogBrowserManager();
                FileDialog fileDialog = new FileDialog(parentShell, 8192);
                fileDialog.setText("Select a file to save generated script contents");
                String cfgFilePath = EditorUtils.getCurrentFileRealPath();
                if (cfgFilePath != null && !cfgFilePath.isEmpty()) {
                    String cfgParentStr = new File(cfgFilePath).getParent();
                    fileDialog.setFilterPath(cfgParentStr);
                } else {
                    String currentlySelectedContainerAbsolutePath = EditorUtils.getCurrentSelectedContainerPath();
                    if (currentlySelectedContainerAbsolutePath != null) {
                        fileDialog.setFilterPath(currentlySelectedContainerAbsolutePath);
                    } else {
                        String recentDir = lbManager.getRecentHostDir("localhost");
                        if (recentDir != null && !recentDir.isEmpty()) {
                            fileDialog.setFilterPath(recentDir);
                        } else {
                            URI workspaceUri = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                            String workspacePathString = new File(workspaceUri).getAbsolutePath();
                            fileDialog.setFilterPath(workspacePathString);
                        }
                    }
                }
                fileDialog.setFileName("lb-script.sh");
                fileDialog.setFilterExtensions(new String[]{"*.sh;*.bat"});
                File selectedScriptFile = this.getNewScriptFile(fileDialog);
                if (selectedScriptFile != null) {
                    lbManager.setRecentHostDir("localhost", selectedScriptFile.getParent());
                    ScriptRecorderManager.getInstance().startRecording(selectedScriptFile);
                    RecordingToggleHandler.setCommandState(trigger, command, true);
                } else {
                    RecordingToggleHandler.setCommandState(trigger, command, false);
                }
            }
        }
        catch (Exception e) {
            String message = "Unhandled Exception in log browser recording handler: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new ExecutionException(message, (Throwable)e);
        }
        return null;
    }

    private static boolean getCommandState(Command command) throws ExecutionException {
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state == null) {
            throw new ExecutionException("The command does not have a toggle state");
        }
        if (!(state.getValue() instanceof Boolean)) {
            throw new ExecutionException("The command's toggle state doesn't contain a boolean value");
        }
        boolean oldValue = (Boolean)state.getValue();
        state.setValue((Object)new Boolean(!oldValue));
        return oldValue;
    }

    private static void setCommandState(Object trigger, Command command, boolean isRecording) throws ExecutionException {
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state == null) {
            throw new ExecutionException("The command does not have a toggle state");
        }
        if (!(state.getValue() instanceof Boolean)) {
            throw new ExecutionException("The command's toggle state doesn't contain a boolean value");
        }
        state.setValue((Object)isRecording);
        RecordingToggleHandler.setButtonImage(trigger, isRecording);
    }

    private static void setButtonImage(Object trigger, boolean isRecording) {
        if (trigger instanceof Event) {
            Event e = (Event)trigger;
            if (e.widget instanceof ToolItem) {
                ToolItem ti = (ToolItem)e.widget;
                ImageDescriptor desc = isRecording ? LogBrowserUiPlugin.getImageDescriptor("/icons/stop-record-16x16.png") : LogBrowserUiPlugin.getImageDescriptor("/icons/start-record-16x16.png");
                ti.setImage(desc.createImage());
            }
        }
    }

    private File getNewScriptFile(FileDialog fileDialog) {
        File scriptFile;
        String fileName = null;
        boolean done = false;
        while (!done) {
            String message;
            MessageBox mb;
            String errorMessage;
            fileName = fileDialog.open();
            if (fileName == null) {
                done = true;
            } else {
                File file = new File(fileName);
                if (file.exists()) {
                    MessageBox mb2 = new MessageBox(fileDialog.getParent(), 200);
                    mb2.setMessage(String.valueOf(fileName) + " already exists. Do you want to replace it?");
                    done = mb2.open() == 64;
                } else {
                    done = true;
                }
            }
            if (!done || fileName == null || fileName.isEmpty()) continue;
            scriptFile = new File(new Path(fileName).toOSString());
            if (scriptFile.exists()) {
                boolean couldDelete = false;
                errorMessage = null;
                try {
                    couldDelete = scriptFile.delete();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
                if (!couldDelete) {
                    mb = new MessageBox(fileDialog.getParent(), 40);
                    message = "Unable to delete existing file '" + fileName + "':\n";
                    message = errorMessage != null ? String.valueOf(message) + errorMessage : String.valueOf(message) + "Perhaps you do not have access to the file?";
                    mb.setMessage(message);
                    mb.open();
                    done = false;
                    continue;
                }
            }
            boolean couldCreateFile = false;
            errorMessage = null;
            try {
                couldCreateFile = scriptFile.createNewFile();
            }
            catch (IOException e) {
                errorMessage = e.getMessage();
            }
            if (couldCreateFile) continue;
            mb = new MessageBox(fileDialog.getParent(), 40);
            message = "Unable to create file file '" + fileName + "':\n";
            message = errorMessage != null ? String.valueOf(message) + errorMessage : String.valueOf(message) + "Perhaps you do not have access to the directory?";
            mb.setMessage(message);
            mb.open();
            done = false;
        }
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        scriptFile = new File(new Path(fileName).toOSString());
        return scriptFile;
    }
}

