/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.handlers;

import com.vmware.vide.utils.xml.JaxbUtils;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import com.vmware.vide.vlogbrowser.core.script.api.LogBrowserScriptRecorderManager;
import com.vmware.vide.vlogbrowser.core.utils.WsUtils;
import com.vmware.vide.vlogbrowser.core.ws.model.FilterResult;
import com.vmware.vide.vlogbrowser.ui.dialogs.FilterDialog;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.runners.LogFilterRunner;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class FilterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            Shell shell = window.getShell();
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor instanceof LogBrowserEditor) {
                try {
                    LogBrowserEditor vlbEditor = (LogBrowserEditor)editor;
                    LogTableViewer myLogTableViewer = vlbEditor.getLogTableViewer();
                    LogFilter myLogFilter = myLogTableViewer.getMyLogFilter();
                    ILogBrowserScriptRecorder recorder = LogBrowserScriptRecorderManager.getInstance().getRecorder();
                    String resName = vlbEditor.getConfigFileName();
                    String prjName = vlbEditor.getProjectName();
                    if (myLogFilter.isJustAKeyword()) {
                        myLogFilter = new LogFilter("", 0, 2);
                        myLogFilter.setFirstKeyword(myLogTableViewer.getTxtFilterStr());
                        int numSurrLines = Integer.parseInt(myLogTableViewer.getCboFilterAddLinesStr());
                        myLogFilter.setNumSurroundingLines(numSurrLines);
                    }
                    Map<String, LogFilter> namedLogFilters = myLogTableViewer.getNamedLogFilters();
                    String savedFiltersFilePath = myLogTableViewer.getExternalFiltersFilePath();
                    FilterDialog myFilterDialog = new FilterDialog(shell, myLogFilter, namedLogFilters, savedFiltersFilePath, vlbEditor);
                    myFilterDialog.open();
                    int dialogResult = myFilterDialog.getReturnCode();
                    if (dialogResult != 0) break block10;
                    myLogFilter = myFilterDialog.getMyLogFilter();
                    if (myFilterDialog.getLastButtonPushed().equals("Unfilter and Clear Form")) {
                        recorder.applyFilterByName(prjName, resName, "");
                        myLogTableViewer.setBtnFilterStr("Filter");
                        myLogTableViewer.setCboFilterAddLinesStr("0");
                        myLogTableViewer.setTxtFilterStr("");
                        myLogTableViewer.setTxtFilterEditable(true);
                    } else {
                        myLogTableViewer.setBtnFilterStr("Unfilter");
                        String aroundString = Integer.toString(myLogFilter.getNumSurroundingLines());
                        myLogTableViewer.setCboFilterAddLinesStr(aroundString);
                        myLogTableViewer.setTxtFilterStr(myLogFilter.getName());
                        myLogTableViewer.setTxtFilterEditable(false);
                        try {
                            FilterResult filter = WsUtils.createFilterResult(null, (LogFilter)myLogFilter);
                            String prettyXml = JaxbUtils.toPrettyXml(FilterResult.class, (Object)filter, (boolean)false);
                            recorder.saveFilter(prjName, resName, myLogFilter.getName(), prettyXml);
                        }
                        catch (Exception exception) {}
                    }
                    myLogTableViewer.setExternalFiltersFilePath(myFilterDialog.getExternalFiltersFilePath());
                    LogFilterRunner lfRunner = new LogFilterRunner(myLogTableViewer, myLogFilter);
                    try {
                        new ProgressMonitorDialog(vlbEditor.getSite().getShell()).run(false, false, (IRunnableWithProgress)lfRunner);
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)vlbEditor.getSite().getShell(), (String)"Error", (String)("While trying to set the filter keyword, an error occurred: " + e1.getMessage()));
                        e1.printStackTrace();
                    }
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)("While trying to set the filter keyword, an error occurred: " + e1.getMessage()));
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }
}

