/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightCellModifier;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElementList;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightLabelProvider;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.IHighlightListViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class HighlightTableViewer {
    private Table table;
    private TableViewer tableViewer;
    private HighlightElementList elementList;

    public HighlightTableViewer(Composite parent, HighlightElementList highlightElementList) {
        this.elementList = highlightElementList;
        this.addChildControls(parent);
    }

    private void addChildControls(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new HighlightContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HighlightLabelProvider());
        this.tableViewer.setInput((Object)this.elementList);
        this.createButtons(composite);
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setWidth(14);
        column = new TableColumn(this.table, 16384);
        column.setText(ColumnNames.KEYWORD.toString());
        column.setWidth(180);
        column = new TableColumn(this.table, 16384);
        column.setText(ColumnNames.COLOR.toString());
        column.setWidth(130);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(ColumnNames.getArray());
        CellEditor[] cellEditors = new CellEditor[ColumnNames.values().length];
        cellEditors[ColumnNames.ENABLE.ordinal()] = new CheckboxCellEditor((Composite)this.table);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        cellEditors[ColumnNames.KEYWORD.ordinal()] = textEditor;
        cellEditors[ColumnNames.COLOR.ordinal()] = new ColorCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new HighlightCellModifier(this));
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 128);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Button add = new Button(composite, 8);
        add.setText("Add");
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightTableViewer.this.elementList.createElement();
            }
        });
        Button remove = new Button(composite, 8);
        remove.setText("Remove");
        gridData = new GridData();
        gridData.widthHint = 80;
        remove.setLayoutData((Object)gridData);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightElement element = (HighlightElement)((IStructuredSelection)HighlightTableViewer.this.tableViewer.getSelection()).getFirstElement();
                if (element != null) {
                    HighlightTableViewer.this.elementList.removeElement(element);
                }
            }
        });
    }

    public HighlightElementList getElementList() {
        return this.elementList;
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    public static enum ColumnNames {
        ENABLE,
        KEYWORD,
        COLOR;


        public static String[] getArray() {
            return new String[]{ENABLE.toString(), KEYWORD.toString(), COLOR.toString()};
        }

        public String toString() {
            String name = this.name();
            String result = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1).toLowerCase();
            return result;
        }
    }

    class HighlightContentProvider
    implements IStructuredContentProvider,
    IHighlightListViewer {
        HighlightContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((HighlightElementList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((HighlightElementList)oldInput).removeChangeListener(this);
            }
        }

        public Object[] getElements(Object parent) {
            return HighlightTableViewer.this.elementList.getElements().toArray();
        }

        public void dispose() {
            HighlightTableViewer.this.elementList.removeChangeListener(this);
        }

        @Override
        public void addHighlightElement(HighlightElement element) {
            HighlightTableViewer.this.tableViewer.add((Object)element);
            this.setSelection(element);
        }

        @Override
        public void removeHighlightElement(HighlightElement element) {
            HighlightTableViewer.this.tableViewer.remove((Object)element);
            this.setSelection(HighlightTableViewer.this.elementList.getLastElement());
        }

        @Override
        public void updateHighlightElement(HighlightElement element) {
            HighlightTableViewer.this.tableViewer.update((Object)element, null);
            this.setSelection(null);
        }

        private void setSelection(HighlightElement element) {
            if (element != null) {
                HighlightTableViewer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            } else {
                HighlightTableViewer.this.tableViewer.setSelection((ISelection)new StructuredSelection());
            }
            HighlightTableViewer.this.tableViewer.refresh();
        }
    }
}

