/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightTableViewer;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HighlightLabelProvider
extends StyledCellLabelProvider {
    private static ImageRegistry imageRegistry = new ImageRegistry();

    static {
        imageRegistry.put("/icons/checked.png", ImageDescriptor.createFromFile(HighlightTableViewer.class, (String)"/icons/checked.png"));
        imageRegistry.put("/icons/unchecked.png", ImageDescriptor.createFromFile(HighlightTableViewer.class, (String)"/icons/unchecked.png"));
    }

    public void update(ViewerCell cell) {
        HighlightElement element = (HighlightElement)cell.getElement();
        int columnIndex = cell.getColumnIndex();
        cell.setText(this.getColumnText(element, columnIndex));
        cell.setImage(this.getColumnImage(element, columnIndex));
        cell.setBackground(this.getColumnColor(element, columnIndex));
        cell.setFont(Display.getCurrent().getSystemFont());
        cell.setStyleRanges(null);
        super.update(cell);
    }

    private String getColumnText(HighlightElement element, int columnIndex) {
        if (columnIndex == HighlightTableViewer.ColumnNames.KEYWORD.ordinal()) {
            return element.getKeyword();
        }
        if (columnIndex == HighlightTableViewer.ColumnNames.COLOR.ordinal()) {
            return HighlightUtil.colorToString(element.getColor());
        }
        return "";
    }

    private Image getColumnImage(HighlightElement element, int columnIndex) {
        if (columnIndex == HighlightTableViewer.ColumnNames.ENABLE.ordinal()) {
            String key = "";
            key = element.isEnable() ? "/icons/checked.png" : "/icons/unchecked.png";
            return imageRegistry.get(key);
        }
        return null;
    }

    private Color getColumnColor(HighlightElement element, int columnIndex) {
        if (columnIndex == HighlightTableViewer.ColumnNames.COLOR.ordinal()) {
            RGB elementRGBColor = element.getColor();
            return new Color((Device)Display.getCurrent(), elementRGBColor);
        }
        return Display.getCurrent().getSystemColor(1);
    }
}

