/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.IHighlightListViewer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.RGB;

public class HighlightElementList {
    private List<HighlightElement> elements = new ArrayList<HighlightElement>();
    private Set<IHighlightListViewer> changeListeners = new HashSet<IHighlightListViewer>();

    public HighlightElement createElement() {
        HighlightElement highlightElement = new HighlightElement();
        this.addElement(highlightElement);
        return highlightElement;
    }

    public void createElement(boolean enable, String keyword, RGB color) {
        HighlightElement highlightElement = new HighlightElement(enable, keyword, color);
        this.addElement(highlightElement);
    }

    public void addElement(HighlightElement highlightElement) {
        this.elements.add(highlightElement);
        for (IHighlightListViewer highlightListViewer : this.changeListeners) {
            highlightListViewer.addHighlightElement(highlightElement);
        }
    }

    public void removeElement(HighlightElement element) {
        this.elements.remove(element);
        for (IHighlightListViewer viewer : this.changeListeners) {
            viewer.removeHighlightElement(element);
        }
    }

    public void elementChanged(HighlightElement element) {
        for (IHighlightListViewer viewer : this.changeListeners) {
            viewer.updateHighlightElement(element);
        }
    }

    public void removeChangeListener(IHighlightListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IHighlightListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public List<HighlightElement> getElements() {
        return this.elements;
    }

    public HighlightElement getLastElement() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return null;
    }
}

