/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightTableViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.TableItem;

public class HighlightCellModifier
implements ICellModifier {
    private HighlightTableViewer highlightTableViewer;

    public HighlightCellModifier(HighlightTableViewer highlightTableViewer) {
        this.highlightTableViewer = highlightTableViewer;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof HighlightElement) {
            HighlightElement highlightElement = (HighlightElement)element;
            if (HighlightTableViewer.ColumnNames.ENABLE.toString().equals(property)) {
                return highlightElement.isEnable();
            }
            if (HighlightTableViewer.ColumnNames.KEYWORD.toString().equals(property)) {
                return highlightElement.getKeyword();
            }
            if (HighlightTableViewer.ColumnNames.COLOR.toString().equals(property)) {
                return highlightElement.getColor();
            }
        }
        return "";
    }

    public void modify(Object element, String property, Object value) {
        TableItem tableItem;
        Object tableItemData;
        if (element instanceof TableItem && (tableItemData = (tableItem = (TableItem)element).getData()) instanceof HighlightElement) {
            RGB colorValue;
            HighlightElement highlightElement = (HighlightElement)tableItemData;
            boolean fireModification = false;
            if (HighlightTableViewer.ColumnNames.ENABLE.toString().equals(property)) {
                boolean booleanValue = (Boolean)value;
                if (booleanValue != highlightElement.isEnable()) {
                    highlightElement.setEnable(booleanValue);
                    fireModification = true;
                }
            } else if (HighlightTableViewer.ColumnNames.KEYWORD.toString().equals(property)) {
                String stringValue = ((String)value).trim();
                if (!stringValue.equals(highlightElement.getKeyword())) {
                    highlightElement.setKeyword(stringValue);
                    fireModification = true;
                }
            } else if (HighlightTableViewer.ColumnNames.COLOR.toString().equals(property) && !(colorValue = (RGB)value).equals((Object)highlightElement.getColor())) {
                highlightElement.setColor(colorValue);
                fireModification = true;
            }
            if (fireModification) {
                this.highlightTableViewer.getElementList().elementChanged(highlightElement);
            }
        }
    }
}

