/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectLogsForChartDialog
extends Dialog {
    private static final String OPEN_BTN_LABEL = "OK";
    private static final String CLOSE_ALIAS_LABEL = "Cancel";
    private static final int OPEN_BTN_ID = 1025;
    private Table dialogTable;
    List<ILogFile> listLogFile;
    LogChartController logChartContainer;
    private HashMap<TableItem, ILogFile> mapTableItemEditor;
    private GridData fgridData;

    public SelectLogsForChartDialog(Shell parentShell, LogChartController logChartContainer, List<ILogFile> listLogFile) {
        super(parentShell);
        this.logChartContainer = logChartContainer;
        this.listLogFile = listLogFile;
        this.mapTableItemEditor = new HashMap();
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 12;
        gridLayout.marginHeight = 12;
        composite.setLayout((Layout)gridLayout);
        Label message = new Label(composite, 0);
        message.setText("Select log files to show in activity graph:");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        message.setLayoutData((Object)gridData);
        this.dialogTable = new Table(composite, 2080);
        this.fgridData = new GridData();
        this.fgridData.verticalAlignment = 4;
        this.fgridData.horizontalAlignment = 4;
        this.fgridData.grabExcessHorizontalSpace = true;
        this.fgridData.minimumWidth = 250;
        this.fgridData.heightHint = 200;
        this.dialogTable.setLayoutData((Object)this.fgridData);
        Composite comp2 = new Composite(composite, 0);
        comp2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        comp2.setLayout((Layout)gl_composite);
        Button selectAll = new Button(comp2, 0);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectLogsForChartDialog.this.selectAll(true);
            }
        });
        selectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        selectAll.setText("Select &All");
        Button deselectAll = new Button(comp2, 0);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectLogsForChartDialog.this.selectAll(false);
            }
        });
        deselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        deselectAll.setText("&Deselect All");
        Label vfiller = new Label(comp2, 0);
        vfiller.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        for (ILogFile logFile : this.listLogFile) {
            TableItem item = new TableItem(this.dialogTable, 0);
            item.setText(logFile.getName());
            item.setChecked(this.logChartContainer.isLogOpenedOnChart(logFile));
            this.mapTableItemEditor.put(item, logFile);
        }
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add Log File(s) to Graph");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, OPEN_BTN_LABEL, true);
        this.createButton(parent, 12, CLOSE_ALIAS_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 1) {
            super.cancelPressed();
        } else if (buttonType == 12) {
            super.cancelPressed();
        } else if (buttonType == 1025) {
            TableItem[] tableItem;
            ArrayList<ILogFile> listSelectedLogFiles = new ArrayList<ILogFile>();
            TableItem[] tableItemArray = tableItem = this.dialogTable.getItems();
            int n = tableItem.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    ILogFile logFile = this.mapTableItemEditor.get(item);
                    listSelectedLogFiles.add(logFile);
                }
                ++n2;
            }
            this.logChartContainer.buildChart(listSelectedLogFiles);
            super.close();
        }
    }

    private void selectAll(boolean flag) {
        TableItem[] items = this.dialogTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            item.setChecked(flag);
            ++i;
        }
    }
}

