/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindByDateDialog
extends Dialog {
    public static final String DIALOG_TITLE = "Find by Timestamp or Adjust All Timestamps";
    public static final String FIND_BUTTON_TEXT = "&Find";
    public static final String ADJUST_BUTTON_TEXT = "&Adjust";
    public static final String CLEAR_ADJ_LABEL = "&Clear Adjustment";
    public static final String CLOSE_ALIAS_LABEL = "Close";
    public static final String DIALOG_MESSAGE = MessageFormat.format("&Specify the date and click {0} to find log entry, or click {1} to adjust date/time in all log entries:", "&Find", "&Adjust");
    public static final String SELECTED_DATE_LABEL = "Actual selected date: ";
    public static final String MOD_DATE_LABEL = "Adjusted appearance: ";
    public static final String DATE_DELTA_LABEL = "Time difference: ";
    public static final int FIND_BTN_ID = 1025;
    public static final int ADJUST_BTN_ID = 1026;
    public static final int CLEAR_ADJ_BTN_ID = 1027;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";
    private Text txtDateInput;
    private Date selectedDateActual;
    private Date selectedDateAdjusted;
    private Calendar findCalendar;
    private LogBrowserEditor myEditor;
    private LogTableViewer myLogTableViewer;
    private DateFormat stdDateFormat;
    private Label lblSelectedDateValue;
    private Label lblAdjustedDateValue;
    private Label lblDateDeltaValue;
    private Label lblErrorMsg;
    private DateTime datePicker;
    private DateTime timePicker;

    public FindByDateDialog(Shell parentShell, Date selectedDateActual, Date selectedDateAdjusted, LogBrowserEditor myEditor, LogTableViewer logTableViewer) {
        super(parentShell);
        this.setShellStyle(2160);
        this.selectedDateActual = selectedDateActual;
        this.selectedDateAdjusted = selectedDateAdjusted;
        this.findCalendar = new GregorianCalendar();
        if (selectedDateAdjusted != null) {
            this.findCalendar.setTime(selectedDateAdjusted);
        }
        this.myEditor = myEditor;
        this.myLogTableViewer = logTableViewer;
        this.stdDateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd_composite = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd_composite);
        GridLayout compositeGridLO = new GridLayout(2, false);
        compositeGridLO.marginWidth = 12;
        compositeGridLO.marginHeight = 12;
        composite.setLayout((Layout)compositeGridLO);
        Label lblDialogPrompt = new Label(composite, 64);
        lblDialogPrompt.setText(DIALOG_MESSAGE);
        GridData lblGridData = new GridData(4, 0x1000000, true, false, 2, 1);
        lblGridData.widthHint = 500;
        lblDialogPrompt.setLayoutData((Object)lblGridData);
        this.datePicker = new DateTime(composite, 1024);
        this.datePicker.setDate(this.findCalendar.get(1), this.findCalendar.get(2), this.findCalendar.get(5));
        this.datePicker.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        this.datePicker.pack();
        this.datePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindByDateDialog.this.modDateInputFromDTControls();
            }
        });
        Label lblTime = new Label(composite, 0);
        lblTime.setText("&Time: ");
        GridData data1 = new GridData();
        data1.verticalIndent = 5;
        lblTime.setLayoutData((Object)data1);
        this.timePicker = new DateTime(composite, 128);
        this.timePicker.setTime(this.findCalendar.get(11), this.findCalendar.get(12), this.findCalendar.get(13));
        GridData fpGridData = new GridData(4, 0x1000000, false, false);
        this.timePicker.setLayoutData((Object)fpGridData);
        this.timePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindByDateDialog.this.modDateInputFromDTControls();
            }
        });
        Label lblTextInputBox = new Label(composite, 0);
        lblTextInputBox.setText("&Date/time to search or adjust: ");
        this.txtDateInput = new Text(composite, 2048);
        this.txtDateInput.setText(this.stdDateFormat.format(this.findCalendar.getTime()));
        this.txtDateInput.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.txtDateInput.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                FindByDateDialog.this.lblErrorMsg.setText("");
            }
        });
        Label lblSelectedDateName = new Label(composite, 0);
        lblSelectedDateName.setText(SELECTED_DATE_LABEL);
        GridData gdLabel = new GridData();
        gdLabel.verticalIndent = 10;
        gdLabel.horizontalAlignment = 16384;
        lblSelectedDateName.setLayoutData((Object)gdLabel);
        this.lblSelectedDateValue = new Label(composite, 0);
        GridData data2 = new GridData();
        data2.verticalAlignment = 1024;
        data2.horizontalAlignment = 4;
        this.lblSelectedDateValue.setLayoutData((Object)data2);
        Label lblAdjustedDateName = new Label(composite, 0);
        lblAdjustedDateName.setText(MOD_DATE_LABEL);
        gdLabel = new GridData();
        gdLabel.horizontalAlignment = 16384;
        lblAdjustedDateName.setLayoutData((Object)gdLabel);
        this.lblAdjustedDateValue = new Label(composite, 0);
        gdLabel = new GridData();
        gdLabel.horizontalAlignment = 4;
        this.lblAdjustedDateValue.setLayoutData((Object)gdLabel);
        Label lblDateDeltaName = new Label(composite, 0);
        lblDateDeltaName.setText(DATE_DELTA_LABEL);
        gdLabel = new GridData();
        gdLabel.horizontalAlignment = 16384;
        lblDateDeltaName.setLayoutData((Object)gdLabel);
        this.lblDateDeltaValue = new Label(composite, 0);
        this.setDateDeltaLabels(this.selectedDateActual, this.selectedDateAdjusted);
        gdLabel = new GridData();
        gdLabel.horizontalAlignment = 16384;
        this.lblDateDeltaValue.setLayoutData((Object)gdLabel);
        this.lblErrorMsg = new Label(composite, 0);
        this.lblErrorMsg.setText("");
        this.lblErrorMsg.setForeground(Display.getCurrent().getSystemColor(3));
        gdLabel = new GridData();
        gdLabel.horizontalAlignment = 16384;
        gdLabel.verticalIndent = 10;
        this.lblErrorMsg.setLayoutData((Object)gdLabel);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1026, ADJUST_BUTTON_TEXT, false);
        this.createButton(parent, 1027, CLEAR_ADJ_LABEL, false);
        this.createButton(parent, 1025, FIND_BUTTON_TEXT, false);
        this.createButton(parent, 12, CLOSE_ALIAS_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 1 || buttonType == 12) {
            super.cancelPressed();
        } else {
            try {
                this.findCalendar.setTime(this.stdDateFormat.parse(this.txtDateInput.getText()));
            }
            catch (Exception exception) {
                this.lblErrorMsg.setText("Error parsing date. Use format: yyyy-MM-dd HH:mm:ss.SSS");
                this.lblErrorMsg.pack(true);
                return;
            }
            try {
                switch (buttonType) {
                    case 1025: {
                        this.myLogTableViewer.findClosestDate(this.findCalendar.getTime());
                        this.selectedDateActual = this.myLogTableViewer.getSelectedDate(false);
                        this.selectedDateAdjusted = this.myLogTableViewer.getSelectedDate(true);
                        this.setDateDeltaLabels(this.selectedDateActual, this.selectedDateAdjusted);
                        if (this.myLogTableViewer.isKeepSynched()) {
                            this.myEditor.findByDateInOtherEditors(this.findCalendar.getTime());
                        }
                        break;
                    }
                    case 1026: {
                        if (this.selectedDateActual == null) {
                            this.lblErrorMsg.setText("Close this dialog, select a log entry, and try again.");
                            this.lblErrorMsg.pack(true);
                            return;
                        }
                        long dateDelta = this.findCalendar.getTime().getTime() - this.selectedDateActual.getTime();
                        if (this.myLogTableViewer.applyDateDelta(dateDelta)) {
                            this.myEditor.saveDateDelta(dateDelta);
                        }
                        this.selectedDateAdjusted.setTime(this.selectedDateActual.getTime() + dateDelta);
                        this.findCalendar.setTime(this.selectedDateAdjusted);
                        this.setDateDeltaLabels(this.selectedDateActual, this.selectedDateAdjusted);
                        HttpLogger.logActivity((String)"vlogbrowser", (String)"UseAdjustTime");
                        break;
                    }
                    case 1027: {
                        if (this.myLogTableViewer.applyDateDelta(0L)) {
                            this.myEditor.saveDateDelta(0L);
                        }
                        if (this.selectedDateAdjusted != null) {
                            this.selectedDateAdjusted.setTime(this.selectedDateActual.getTime());
                            this.findCalendar.setTime(this.selectedDateAdjusted);
                            this.setDateDeltaLabels(this.selectedDateActual, this.selectedDateAdjusted);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.lblErrorMsg.setText("Error changing date delta: " + e.getMessage());
                this.lblErrorMsg.pack(true);
                return;
            }
            this.lblErrorMsg.setText("");
        }
    }

    protected void modDateInputFromDTControls() {
        this.lblErrorMsg.setText("");
        this.findCalendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), this.timePicker.getHours(), this.timePicker.getMinutes(), this.timePicker.getSeconds());
        this.findCalendar.clear(14);
        this.txtDateInput.setText(this.stdDateFormat.format(this.findCalendar.getTime()));
    }

    protected void setDateDeltaLabels(Date actualDate, Date adjustedDate) {
        if (actualDate == null || adjustedDate == null) {
            this.lblSelectedDateValue.setText("No Log Entry Selected");
            this.lblSelectedDateValue.setForeground(Display.getCurrent().getSystemColor(3));
            this.lblAdjustedDateValue.setText("");
            this.lblDateDeltaValue.setText("");
            return;
        }
        this.lblSelectedDateValue.setText(this.stdDateFormat.format(actualDate));
        this.lblSelectedDateValue.setForeground(Display.getCurrent().getSystemColor(2));
        this.lblSelectedDateValue.pack(true);
        this.lblAdjustedDateValue.setText(this.stdDateFormat.format(adjustedDate));
        this.lblAdjustedDateValue.pack(true);
        long diff = adjustedDate.getTime() - actualDate.getTime();
        if (diff != 0L) {
            this.lblAdjustedDateValue.setForeground(Display.getCurrent().getSystemColor(4));
        } else {
            this.lblAdjustedDateValue.setForeground(Display.getCurrent().getSystemColor(2));
        }
        this.lblDateDeltaValue.setText(LogFileUtils.formatElapsedTime((long)diff));
        this.lblDateDeltaValue.pack(true);
    }
}

