/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FilterDialogRow {
    public static final String[] BOOL_CONN_VALUES = new String[]{"", "AND", "OR"};
    public static final String BOOL_CONN_TOOLTIP_TEXT = "Select 'AND' or 'OR' to expand the filter to multiple terms. Set to <blank> to disable additional filter terms.";
    public static final String NOT = "Not";
    public static final String NOT_TOOLTIP_TEXT = "Check this box to negate this term and match all log entries that DO NOT contain this keyword.";
    public static final String KEYWORD = "Keyword";
    public static final String KEYWORD_TOOLTIP_TEXT = "Enter a keyword to see only log entries that contain that keyword";
    public static final String REGEX = "RegEx";
    public static final String REGEX_TOOLTIP_TEXT = "Check this box to indicate that this keyword should be treated as a Regular Expression";
    public static final String PARENS_TOOLTIP_TEXT = "These parentheses group the terms on this row.";
    private Combo cboRowBooleanConn;
    private Label lblLeftParens;
    private Label lblRightParens;
    public static final int NUM_CTRLS_PER_CELL = 4;
    private List<FilterDialogCell> myFilterDialogRow;

    public FilterDialogRow(Composite comp, boolean hideRowBooleanConnector, int columnCount, Font parensFont, final Listener expansionListener, int horizSpan) {
        this.myFilterDialogRow = new ArrayList<FilterDialogCell>(columnCount);
        if (!hideRowBooleanConnector) {
            this.cboRowBooleanConn = new Combo(comp, 12);
            this.cboRowBooleanConn.setItems(BOOL_CONN_VALUES);
            this.cboRowBooleanConn.setText("");
            this.cboRowBooleanConn.setToolTipText(BOOL_CONN_TOOLTIP_TEXT);
            GridData gridData = new GridData();
            gridData.horizontalSpan = horizSpan;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 16384;
            gridData.horizontalIndent = 100;
            this.cboRowBooleanConn.setLayoutData((Object)gridData);
            this.cboRowBooleanConn.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    if (!FilterDialogRow.this.cboRowBooleanConn.getText().isEmpty()) {
                        FilterDialogRow.this.setFilterDialogCellsEnabled(true);
                        expansionListener.handleEvent(event);
                    } else {
                        FilterDialogRow.this.setFilterDialogCellsEnabled(false);
                    }
                }
            });
            this.cboRowBooleanConn.setEnabled(true);
        }
        this.lblLeftParens = new Label(comp, 0);
        this.lblLeftParens.setText("(");
        this.lblLeftParens.setToolTipText(PARENS_TOOLTIP_TEXT);
        this.lblLeftParens.setFont(parensFont);
        this.lblLeftParens.setEnabled(false);
        int i = 0;
        while (i < columnCount) {
            FilterDialogCell fdc = new FilterDialogCell(comp, i == 0);
            this.myFilterDialogRow.add(fdc);
            ++i;
        }
        this.lblRightParens = new Label(comp, 0);
        this.lblRightParens.setText(")");
        this.lblRightParens.setToolTipText(PARENS_TOOLTIP_TEXT);
        this.lblRightParens.setFont(parensFont);
        this.lblRightParens.setEnabled(false);
    }

    public LogBrowserConsts.BooleanConnector getBooleanConn(int columnNum) {
        Combo boolCombo = null;
        boolCombo = columnNum == 0 ? this.cboRowBooleanConn : this.myFilterDialogRow.get((int)columnNum).cboBooleanConn;
        if (boolCombo.getText().equals(LogBrowserConsts.BooleanConnector.AND.toString())) {
            return LogBrowserConsts.BooleanConnector.AND;
        }
        if (boolCombo.getText().equals(LogBrowserConsts.BooleanConnector.OR.toString())) {
            return LogBrowserConsts.BooleanConnector.OR;
        }
        return LogBrowserConsts.BooleanConnector.SKIP;
    }

    public void setBooleanConn(int columnNum, LogBrowserConsts.BooleanConnector boolConn) {
        Combo boolCombo = null;
        boolCombo = columnNum == 0 ? this.cboRowBooleanConn : this.myFilterDialogRow.get((int)columnNum).cboBooleanConn;
        if (boolConn == LogBrowserConsts.BooleanConnector.SKIP) {
            boolCombo.setText("");
        } else {
            boolCombo.setText(boolConn.toString());
        }
    }

    public boolean getNegationFlag(int columnNum) {
        return this.myFilterDialogRow.get((int)columnNum).btnNot.getSelection();
    }

    public void setNegationFlag(int columnNum, boolean selected) {
        this.myFilterDialogRow.get((int)columnNum).btnNot.setSelection(selected);
    }

    public String getKeyword(int columnNum) {
        return this.myFilterDialogRow.get((int)columnNum).txtKeyword.getText();
    }

    public void setKeyword(int columnNum, String kywd) {
        this.myFilterDialogRow.get((int)columnNum).txtKeyword.setText(kywd);
    }

    public void setFocus(int columnNum) {
        this.myFilterDialogRow.get((int)columnNum).txtKeyword.setFocus();
    }

    public boolean getRegExFlag(int columnNum) {
        return this.myFilterDialogRow.get((int)columnNum).btnRegEx.getSelection();
    }

    public void setRegExFlag(int columnNum, boolean selected) {
        this.myFilterDialogRow.get((int)columnNum).btnRegEx.setSelection(selected);
    }

    public int getColumnCount() {
        return this.myFilterDialogRow.size();
    }

    protected void clear() {
        this.lblLeftParens.dispose();
        this.lblRightParens.dispose();
        if (this.cboRowBooleanConn != null) {
            this.cboRowBooleanConn.dispose();
        }
        for (FilterDialogCell fdc : this.myFilterDialogRow) {
            fdc.btnNot.dispose();
            fdc.btnRegEx.dispose();
            fdc.txtKeyword.dispose();
            if (fdc.cboBooleanConn == null) continue;
            fdc.cboBooleanConn.dispose();
        }
        this.myFilterDialogRow.clear();
    }

    protected void setEnabled(boolean enabled) {
        if (this.cboRowBooleanConn != null) {
            this.cboRowBooleanConn.setEnabled(enabled);
        }
        if (this.cboRowBooleanConn == null || !this.cboRowBooleanConn.getText().isEmpty()) {
            this.setFilterDialogCellsEnabled(enabled);
        }
    }

    private void setFilterDialogCellsEnabled(boolean enabled) {
        FilterDialogCell firstCell = this.myFilterDialogRow.get(0);
        firstCell.setKeywdAndFlagsEnabled(enabled);
        int n = 1;
        while (n < this.myFilterDialogRow.size()) {
            FilterDialogCell nthCell = this.myFilterDialogRow.get(n);
            nthCell.cboBooleanConn.setEnabled(enabled);
            if (!nthCell.cboBooleanConn.getText().isEmpty() || !enabled) {
                nthCell.setKeywdAndFlagsEnabled(enabled);
            }
            ++n;
        }
        this.lblLeftParens.setEnabled(enabled);
        this.lblRightParens.setEnabled(enabled);
    }

    private class FilterDialogCell {
        Combo cboBooleanConn;
        Button btnNot;
        Text txtKeyword;
        Button btnRegEx;

        FilterDialogCell(Composite comp, boolean hideBooleanConnector) {
            if (!hideBooleanConnector) {
                this.cboBooleanConn = new Combo(comp, 12);
                this.cboBooleanConn.setItems(BOOL_CONN_VALUES);
                this.cboBooleanConn.setToolTipText(FilterDialogRow.BOOL_CONN_TOOLTIP_TEXT);
                this.cboBooleanConn.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        if (FilterDialogCell.this.cboBooleanConn.getText().isEmpty()) {
                            FilterDialogCell.this.setKeywdAndFlagsEnabled(false);
                        } else {
                            FilterDialogCell.this.setKeywdAndFlagsEnabled(true);
                        }
                    }
                });
                this.cboBooleanConn.setEnabled(false);
            }
            this.btnNot = new Button(comp, 32);
            this.btnNot.setText(FilterDialogRow.NOT);
            this.btnNot.setToolTipText(FilterDialogRow.NOT_TOOLTIP_TEXT);
            this.btnNot.setEnabled(false);
            this.txtKeyword = new Text(comp, 2048);
            this.txtKeyword.setToolTipText(FilterDialogRow.KEYWORD_TOOLTIP_TEXT);
            GridData gridData = new GridData();
            gridData.widthHint = 150;
            this.txtKeyword.setLayoutData((Object)gridData);
            this.txtKeyword.setEnabled(false);
            this.btnRegEx = new Button(comp, 32);
            this.btnRegEx.setText(FilterDialogRow.REGEX);
            this.btnRegEx.setToolTipText(FilterDialogRow.REGEX_TOOLTIP_TEXT);
            gridData = new GridData();
            gridData.horizontalAlignment = 16384;
            this.btnRegEx.setLayoutData((Object)gridData);
            this.btnRegEx.setEnabled(false);
        }

        void setKeywdAndFlagsEnabled(boolean enabled) {
            this.btnNot.setEnabled(enabled);
            this.txtKeyword.setEnabled(enabled);
            this.btnRegEx.setEnabled(enabled);
        }
    }
}

