/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddLogFilesDialog
extends Dialog {
    public static final String DIALOG_TITLE = "Add Log Files";
    public static final String ADD_LABEL = "Add";
    public static final String CLOSE_ALIAS_LABEL = "Close";
    public static final String DIALOG_MESSAGE = "Browse for local log files and click 'Add'";
    public static final String TEXT_INPUT_LABEL = "Keyword: ";
    public static final int ADD_BTN_ID = 1025;
    private Text txtLogFiles;
    private Button btnLogFileBrowse;
    private Label lblStatusMsg;
    private LogTableViewer myLogTableViewer;

    public AddLogFilesDialog(Shell parentShell, LogTableViewer logTableViewer) {
        super(parentShell);
        this.myLogTableViewer = logTableViewer;
    }

    protected Control createDialogArea(Composite parent) {
        final Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 12;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        layout.verticalSpacing = 5;
        container.setLayout((Layout)layout);
        Label lblCurrentlyLoaded = new Label(container, 0);
        lblCurrentlyLoaded.setText("&Currently loaded log files:");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        lblCurrentlyLoaded.setLayoutData((Object)gd);
        Text txtCurrentlyLoaded = new Text(container, 2826);
        txtCurrentlyLoaded.setData("name", (Object)"txtCurrentlyLoaded");
        txtCurrentlyLoaded.setText(this.myLogTableViewer.getLogFilesInfoStr().trim());
        txtCurrentlyLoaded.setBackground(Display.getCurrent().getSystemColor(22));
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 3;
        gd3.widthHint = 500;
        gd3.heightHint = 200;
        txtCurrentlyLoaded.setLayoutData((Object)gd3);
        txtCurrentlyLoaded.pack();
        Label lbllocalLogFiles = new Label(container, 0);
        lbllocalLogFiles.setText("&Local log file(s):");
        GridData gdLocalLogFiles = new GridData();
        gdLocalLogFiles.verticalAlignment = 128;
        gdLocalLogFiles.verticalIndent = 5;
        lbllocalLogFiles.setLayoutData((Object)gdLocalLogFiles);
        this.txtLogFiles = new Text(container, 2052);
        this.txtLogFiles.setData("name", (Object)"txtLogFile");
        this.txtLogFiles.setEditable(true);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.txtLogFiles.setLayoutData((Object)gd);
        this.txtLogFiles.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                AddLogFilesDialog.this.lblStatusMsg.setText("");
            }
        });
        this.btnLogFileBrowse = new Button(container, 8);
        this.btnLogFileBrowse.setData("name", (Object)"btnLogFileBrowse");
        this.btnLogFileBrowse.setText("&Browse...");
        this.btnLogFileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String path;
                Shell outerShell = container.getShell();
                FileDialog fileDialog = new FileDialog(outerShell, 2);
                fileDialog.setText("Select File(s)");
                ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
                String recentDir = manager.getRecentHostDir("localhost");
                fileDialog.setFilterPath(recentDir);
                if (fileDialog.open() == null) {
                    return;
                }
                String[] fileNames = fileDialog.getFileNames();
                ArrayList<String> fileList = new ArrayList<String>(fileNames.length);
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    fileList.add(fileName);
                    ++n2;
                }
                Collections.sort(fileList);
                fileNames = fileList.toArray(new String[fileList.size()]);
                if (fileNames == null || fileNames.length == 0) {
                    return;
                }
                String filePath = path = fileDialog.getFilterPath();
                String fileSeparator = System.getProperty("file.separator");
                manager.setRecentHostDir("localhost", path);
                StringBuffer fileNameBuff = new StringBuffer(100);
                String[] stringArray2 = fileNames;
                int n3 = fileNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    if (fileNameBuff.length() > 0) {
                        fileNameBuff.append(';');
                    }
                    String fullPath = String.valueOf(filePath) + fileSeparator + fileName;
                    fileNameBuff.append(fullPath);
                    ++n4;
                }
                AddLogFilesDialog.this.txtLogFiles.setText(fileNameBuff.toString());
                AddLogFilesDialog.this.lblStatusMsg.setText("");
            }
        });
        Label logFormat = new Label(container, 0);
        logFormat.setText("Log format:");
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        gd2.horizontalSpan = 1;
        logFormat.setLayoutData((Object)gd2);
        Label logFormat2 = new Label(container, 0);
        logFormat2.setText(this.myLogTableViewer.getLogFormatName());
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 4;
        gd4.horizontalSpan = 2;
        logFormat2.setLayoutData((Object)gd4);
        this.lblStatusMsg = new Label(container, 0);
        this.lblStatusMsg.setText("");
        this.lblStatusMsg.setForeground(Display.getCurrent().getSystemColor(3));
        GridData gd1 = new GridData();
        gd1.horizontalAlignment = 4;
        gd1.horizontalSpan = 3;
        this.lblStatusMsg.setLayoutData((Object)gd1);
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, ADD_LABEL, true);
        this.createButton(parent, 12, CLOSE_ALIAS_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 1) {
            super.cancelPressed();
        } else if (buttonType == 12) {
            super.cancelPressed();
        } else {
            if (this.txtLogFiles.getText().trim().equals("")) {
                this.lblStatusMsg.setText("Input Error: please choose log files from the local disk");
                this.lblStatusMsg.pack(true);
                return;
            }
            this.myLogTableViewer.addLogFilesToTable("Local", this.txtLogFiles.getText().trim());
            super.close();
        }
    }
}

