/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.ui.chart.LogDatasetManager;
import com.vmware.vide.vlogbrowser.ui.chart.LogSeries;
import com.vmware.vide.vlogbrowser.ui.chart.LogXYDataset;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Collection;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class LogSubplot
extends XYPlot {
    private ILogFile logFile;
    private LogSeries currentSeries;

    public LogSubplot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer, ILogFile logFile, LogDatasetManager logDatasetManager) {
        super(dataset, domainAxis, rangeAxis, renderer);
        this.logFile = logFile;
        this.addSubplotTitle();
        LogSeries series = logDatasetManager.createSeries(logFile);
        this.addReplaceSeries(series, false);
        domainAxis.setRange((Range)series.getxRange());
    }

    public void addReplaceSeries(LogSeries series) {
        this.addReplaceSeries(series, true);
    }

    public void addReplaceSeries(LogSeries series, boolean notify) {
        this.currentSeries = series;
        LogXYDataset dataset = (LogXYDataset)this.getDataset();
        dataset.addReplaceSeries((Comparable)((Object)this.logFile.getName()), series.getData());
        this.readjustVerticalAxis(series);
        if (notify) {
            dataset.fireDatasetChanged();
        }
    }

    private void addSubplotTitle() {
        ValueMarker target = new ValueMarker(0.0);
        target.setLabel(this.logFile.getName());
        target.setLabelFont(new Font("SansSerif", 1, 11));
        target.setLabelAnchor(RectangleAnchor.LEFT);
        target.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
        target.setPaint((Paint)Color.white);
        this.addRangeMarker((Marker)target, Layer.BACKGROUND);
    }

    private void readjustVerticalAxis(LogSeries series) {
        ValueAxis rangeAxis = this.getRangeAxis();
        double lowerBound = series.getyRange().getLowerBound();
        double upperBound = series.getyRange().getUpperBound();
        rangeAxis.setRange(new Range(lowerBound, upperBound * 1.1), true, false);
        Collection listMarker = this.getRangeMarkers(Layer.BACKGROUND);
        for (ValueMarker marker : listMarker) {
            marker.setValue(upperBound * 1.05);
        }
    }

    public ILogFile getLogFile() {
        return this.logFile;
    }

    public boolean isColumnFiltered(int column) {
        return this.currentSeries.isColumnFiltered(column);
    }

    public IFilteredList<LogItem> getFilterList() {
        return this.logFile.getFilterList();
    }
}

