/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.axis.DateAxis;
import org.jfree.data.Range;

public class LogChartDomainAxis
extends DateAxis {
    private static final long serialVersionUID = -2944705662921539620L;
    private static final double MAX_ZOOMIN_MS = 100.0;
    private static final double MAX_ZOOMOUT_MS = 3.1536E11;
    private static final double INITIAL_RANGE = 1.0;
    private static final String WARNING_TITLE = "Warning";
    private static final String WARNING_MESSAGE_ZOOM_IN = "Maximum zoom in allowed is 100 ms.";
    private static final String WARNING_MESSAGE_ZOOM_OUT = "Maximum zoom out allowed is 10 years.";

    public LogChartDomainAxis(String label) {
        super(label);
    }

    public void setRange(Date lower, Date upper) {
        double length = upper.getTime() - lower.getTime();
        if (this.checkRange(length)) {
            super.setRange(lower, upper);
        }
    }

    public void setRange(double lower, double upper) {
        double length = upper - lower;
        if (this.checkRange(length)) {
            super.setRange(lower, upper);
        }
    }

    public void setRange(Range range, boolean turnOffAutoRange, boolean notify) {
        double length = range.getLength();
        if (this.checkRange(length)) {
            super.setRange(range, turnOffAutoRange, notify);
        }
    }

    public void setRange(Range range) {
        double length = range.getLength();
        if (this.checkRange(length)) {
            super.setRange(range);
        }
    }

    private boolean checkRange(double length) {
        if (length < 100.0 && length != 1.0) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openWarning((Shell)shell, (String)WARNING_TITLE, (String)WARNING_MESSAGE_ZOOM_IN);
            return false;
        }
        if (length > 3.1536E11) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openWarning((Shell)shell, (String)WARNING_TITLE, (String)WARNING_MESSAGE_ZOOM_OUT);
            return false;
        }
        return true;
    }
}

