/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.IFilterListener;
import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.chart.ILogItemListener;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.ui.chart.DomainAxisChangeManager;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartBoundsListener;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartComposite;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartDomainAxis;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartRenderer;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartSlider;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartZoom;
import com.vmware.vide.vlogbrowser.ui.chart.LogDatasetManager;
import com.vmware.vide.vlogbrowser.ui.chart.LogSeries;
import com.vmware.vide.vlogbrowser.ui.chart.LogSubplot;
import com.vmware.vide.vlogbrowser.ui.chart.LogXYDataset;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.xy.XYDataset;

public class LogChartController
implements IFilterListener<LogItem> {
    private CombinedDomainXYPlot combinedDomainPlot;
    private LogChartComposite chartComposite;
    private LogDatasetManager logDatasetManager;
    private LogChartDomainAxis domainAxis;
    private DomainAxisChangeManager domainAxisChangeManager;

    public LogChartController(Composite panel) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        panel.setLayout((Layout)gridLayout);
        this.logDatasetManager = new LogDatasetManager();
        this.domainAxis = new LogChartDomainAxis("Time");
        this.combinedDomainPlot = new CombinedDomainXYPlot((ValueAxis)this.domainAxis);
        LogChartZoom logChartZoom = new LogChartZoom(this.combinedDomainPlot);
        this.domainAxisChangeManager = new DomainAxisChangeManager(this.combinedDomainPlot, this.logDatasetManager);
        Label label = new Label(panel, 0);
        label.setText("Scroll chart:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        LogChartSlider logChartSlide = new LogChartSlider(this.combinedDomainPlot);
        logChartSlide.createSlider(panel);
        Label label2 = new Label(panel, 0);
        label2.setText("Zoom chart:");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite buttonsComposite = new Composite(panel, 0);
        GridLayout layout = new GridLayout(10, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        buttonsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 1;
        buttonsComposite.setLayoutData((Object)gridData);
        logChartZoom.createZoomButtons(buttonsComposite);
        this.domainAxisChangeManager.createZoomBackForwardButtons(buttonsComposite);
        this.createChartComposite(panel);
        this.domainAxis.addChangeListener(this.domainAxisChangeManager);
        logChartZoom.addZoomActionListener(logChartSlide);
        this.chartComposite.addControlListener(new LogChartBoundsListener(this.logDatasetManager));
        this.chartComposite.addChartMouseListener(logChartSlide);
    }

    private void createChartComposite(Composite panel) {
        this.combinedDomainPlot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.combinedDomainPlot, true);
        chart.setAntiAlias(false);
        this.chartComposite = new LogChartComposite(panel, 0, chart, true);
        this.chartComposite.setRangeZoomable(false);
        GridLayout parentLayout = (GridLayout)panel.getLayout();
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = parentLayout.numColumns;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.chartComposite.setLayoutData(gridData);
    }

    public void buildChart(List<ILogFile> listSelectedLogFiles) {
        List<LogSubplot> listSubplot = this.getListSubplot();
        int index = listSubplot.size() - 1;
        while (index >= 0) {
            LogSubplot subplot = listSubplot.get(index);
            if (!listSelectedLogFiles.contains(subplot.getLogFile())) {
                this.removePlot(subplot);
            }
            --index;
        }
        for (ILogFile logFile : listSelectedLogFiles) {
            if (this.isLogOpenedOnChart(logFile)) continue;
            this.createPlot(logFile);
        }
    }

    public LogSubplot createPlot(ILogFile logFile) {
        LogChartRenderer renderer = new LogChartRenderer();
        StandardXYToolTipGenerator tt = StandardXYToolTipGenerator.getTimeSeriesInstance();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)tt);
        renderer.setShadowVisible(false);
        renderer.setBaseSeriesVisibleInLegend(false);
        NumberAxis rangeAxis = new NumberAxis("");
        rangeAxis.setAutoRange(false);
        LogSubplot subPlot = new LogSubplot((XYDataset)new LogXYDataset(), (ValueAxis)this.domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer, logFile, this.logDatasetManager);
        subPlot.setDomainGridlinesVisible(false);
        subPlot.setRangeGridlinesVisible(true);
        this.combinedDomainPlot.add((XYPlot)subPlot);
        return subPlot;
    }

    public boolean isLogOpenedOnChart(ILogFile logFile) {
        List<LogSubplot> listSubplot = this.getListSubplot();
        for (LogSubplot subplot : listSubplot) {
            if (!logFile.equals(subplot.getLogFile())) continue;
            return true;
        }
        return false;
    }

    public List<LogSubplot> getListSubplot() {
        return this.combinedDomainPlot.getSubplots();
    }

    public void removePlot(LogSubplot plot) {
        this.combinedDomainPlot.remove((XYPlot)plot);
        if (this.combinedDomainPlot.getSubplots().size() == 0) {
            DateAxis domainAxis = (DateAxis)this.combinedDomainPlot.getDomainAxis();
            domainAxis.setRange((Range)new DateRange(), false, false);
        }
    }

    public void addLogItemListener(ILogItemListener logItemListener) {
        if (this.chartComposite != null) {
            this.chartComposite.addLogItemListener(logItemListener);
        }
    }

    public void removeLogItemListener(ILogItemListener logItemListener) {
        if (this.chartComposite != null) {
            this.chartComposite.removeLogItemListener(logItemListener);
        }
    }

    public void filterPerformed(IFilteredList<LogItem> filterList) {
        if (this.combinedDomainPlot.getSubplots().size() > 0) {
            LogChartDomainAxis domainAxis = (LogChartDomainAxis)this.combinedDomainPlot.getDomainAxis();
            DateRange range = (DateRange)domainAxis.getRange();
            domainAxis.setRange((Range)range);
        }
    }

    public void updatePlot(LogSubplot plot) {
        ILogFile logFile = plot.getLogFile();
        LogSeries series = this.logDatasetManager.createSeries(logFile);
        plot.addReplaceSeries(series);
        this.domainAxis.setRange((Range)series.getxRange());
    }
}

