/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.TargetManagerPlugin;
import com.vmware.vide.vlogbrowser.core.AbstractLogBrowserManager;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.dialogs.LogDialog;
import com.vmware.vide.vlogbrowser.ui.runners.TimedThreadRunner;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UiLogBrowserManager
extends AbstractLogBrowserManager {
    private static final String PREF_CUSTOM_TEMPLATE_DIR = "template-dirs";
    private static final String PREF_HOST = "RecentHost";
    private static final String PREF_DIR = "RecentDir";
    private static final String PREF_FORMAT = "RecentFormat";

    public UiLogBrowserManager() {
        this.loadPreferences();
    }

    public LogxFile[] getLogFormatsByHostService(String connectionName, boolean knownPathOnly) {
        Map map = knownPathOnly ? this.absolutePathFormats : this.allFormats;
        LogxFile[] result = (LogxFile[])map.get(connectionName);
        if (result == null) {
            try {
                boolean showAllTemplates;
                ITarget target;
                ITargetManager targetMgr = TargetManagerPlugin.getTheTargetManager();
                if (connectionName.endsWith("localhost")) {
                    target = targetMgr.findTarget(connectionName);
                    if (target == null && (target = targetMgr.createTarget("localhost", connectionName, connectionName)) == null) {
                        return new LogxFile[0];
                    }
                } else {
                    target = targetMgr.findTarget(connectionName);
                    if (target == null && (target = targetMgr.createTarget("esx", connectionName, connectionName)) == null) {
                        return new LogxFile[0];
                    }
                    target.setUserId("root");
                }
                if (showAllTemplates = this.isShowAllTemplates(connectionName)) {
                    if (this.logxTemplates.isEmpty()) {
                        this.parseLogxTemplates();
                    }
                    return this.logxTemplates.toArray(new LogxFile[0]);
                }
                String hostType = this.getHostType(target, false);
                String hostVer = Utils.getSafeEsxVersion((ITarget)target, (String)hostType);
                result = this.getLogFormatsByHosttype(hostType, hostVer, knownPathOnly);
            }
            catch (Exception e) {
                this.clearHostFormats(connectionName);
                e.printStackTrace();
            }
            if (result == null) {
                result = new LogxFile[]{};
            }
            map.put(connectionName, result);
        }
        return result;
    }

    private void saveMapToPref(Map<String, String> map, IPreferenceStore prefStore, String pref) {
        String[] keys = map.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            String value = map.get(key);
            prefStore.putValue(String.valueOf(pref) + "Key" + i, key);
            prefStore.putValue(String.valueOf(pref) + "Value" + i, value);
            ++i;
        }
    }

    private void restoreMapFromPref(Map<String, String> map, IPreferenceStore prefStore, String pref) {
        int i = 0;
        while (true) {
            String key = prefStore.getString(String.valueOf(pref) + "Key" + i);
            String value = prefStore.getString(String.valueOf(pref) + "Value" + i);
            if (key.length() == 0) break;
            if (value.length() > 0) {
                map.put(key, value);
            }
            ++i;
        }
    }

    public void savePreferences() {
        IPreferenceStore pref = LogBrowserUiPlugin.getDefault().getPreferenceStore();
        String[] dirs = this.fCustomTemplateDirs;
        String merged = "";
        int i = 0;
        while (i < dirs.length) {
            String dir = dirs[i];
            if (merged.length() > 0) {
                merged = String.valueOf(merged) + File.pathSeparator;
            }
            merged = String.valueOf(merged) + dir;
            ++i;
        }
        pref.putValue(PREF_CUSTOM_TEMPLATE_DIR, merged);
        pref.putValue(PREF_HOST, this.fRecentHost);
        this.saveMapToPref(this.fRecentHostDirs, pref, PREF_DIR);
        this.saveMapToPref(this.fRecentHostFormats, pref, PREF_FORMAT);
    }

    public void loadPreferences() {
        IPreferenceStore pref = LogBrowserUiPlugin.getDefault().getPreferenceStore();
        String string = pref.getString(PREF_CUSTOM_TEMPLATE_DIR);
        if (string.length() > 0) {
            String[] dirs = string.split(File.pathSeparator);
            this.fCustomTemplateDirs = dirs;
        }
        this.fRecentHost = pref.getString(PREF_HOST);
        this.restoreMapFromPref(this.fRecentHostDirs, pref, PREF_DIR);
        this.restoreMapFromPref(this.fRecentHostFormats, pref, PREF_FORMAT);
    }

    public LogxFile[] getLogFormatsByHost(String connectionName, boolean knownPathOnly) {
        Map map = knownPathOnly ? this.absolutePathFormats : this.allFormats;
        LogxFile[] result = (LogxFile[])map.get(connectionName);
        if (result == null) {
            try {
                ITargetManager targetMgr = TargetManagerPlugin.getTheTargetManager();
                ITarget target = targetMgr.findTarget(connectionName);
                if (target == null) {
                    return new LogxFile[0];
                }
                boolean showAllTemplates = this.isShowAllTemplates(connectionName);
                if (showAllTemplates) {
                    if (this.logxTemplates.isEmpty()) {
                        this.parseLogxTemplates();
                    }
                    return this.logxTemplates.toArray(new LogxFile[0]);
                }
                String hostType = this.getHostType(target, false);
                String hostVer = Utils.getSafeEsxVersion((ITarget)target, (String)hostType);
                result = this.getLogFormatsByHosttype(hostType, hostVer, knownPathOnly);
            }
            catch (Exception e) {
                this.clearHostFormats(connectionName);
                LogDialog dialog = new LogDialog(Display.getDefault().getActiveShell(), "Error Parsing Templates", null, "A file read error prevented parsing .logx templates for " + connectionName, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setMessage("Error preventing read and parse: " + e.getMessage());
                dialog.setBlockOnOpen(false);
                dialog.open();
                e.printStackTrace();
            }
            if (result == null) {
                result = new LogxFile[]{};
            }
            map.put(connectionName, result);
        }
        return result;
    }

    protected String getSpecificESXType(final ITarget target) {
        if (target == null || !target.getTargetType().equals("esx")) {
            return "Error contacting host";
        }
        final String[] rseResponseStringsArr = new String[2];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                final String connectionName = target.getName();
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            rseResponseStringsArr[0] = target.isVisor() ? "ESXi" : "ESX";
                        }
                        catch (Exception e) {
                            rseResponseStringsArr[0] = "Error contacting host";
                            rseResponseStringsArr[1] = e.getMessage();
                        }
                    }
                };
                Shell shell = Display.getDefault().getActiveShell();
                final TimedThreadRunner timedRunner = new TimedThreadRunner();
                try {
                    new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName("Connecting to " + connectionName + " to determine ESX type...");
                            try {
                                timedRunner.run(new Thread(runnable, "ESX/ESXi check"), 45);
                            }
                            catch (TimeoutException e) {
                                throw new InterruptedException(e.getMessage());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    rseResponseStringsArr[0] = "Error contacting host";
                    rseResponseStringsArr[1] = e.getMessage();
                }
                if (rseResponseStringsArr[0].equals("Error contacting host")) {
                    String errorMsg = "While creating a connection to " + connectionName + " to retrieve information, a failure occurred.\nPlease check the" + " connection to '" + connectionName + "' using the Remote Systems view" + " (Menu:Window-->Show View-->Remote Systems).\n\n\n" + rseResponseStringsArr[1];
                    LogDialog dialog = new LogDialog(shell, "Target Lookup Error", null, "A connection problem prevented contacting " + connectionName, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.setMessage(errorMsg);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                    System.err.println(errorMsg);
                }
            }
        });
        return rseResponseStringsArr[0];
    }

    public LogSystemType getTgzFileType(final String host, final String archiveFilePath) {
        final LogSystemType[] result = new LogSystemType[1];
        IRunnableWithProgress determineHostTypeRunner = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                result[0] = UiLogBrowserManager.this.getArchiveFileType(host, archiveFilePath, monitor);
            }
        };
        try {
            Shell shell = Display.getDefault().getActiveShell();
            new ProgressMonitorDialog(shell).run(false, false, determineHostTypeRunner);
        }
        catch (Exception e) {
            System.err.println("Error determining TGZ File Type: " + e.getMessage());
            e.printStackTrace();
            LogBrowserUiPlugin.log(e);
        }
        return result[0];
    }

    public LogSystemType getTgzFileTypeService(String host, String archiveFilePath) {
        LogSystemType[] result = new LogSystemType[1];
        try {
            result[0] = this.getArchiveFileType(host, archiveFilePath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            System.err.println("Error determining TGZ File Type: " + e.getMessage());
            e.printStackTrace();
            LogBrowserUiPlugin.log(e);
            result[0] = null;
        }
        return result[0];
    }
}

