/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui;

import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.ui.LogBrowserResourceChange;
import com.vmware.vide.vlogbrowser.ui.UiLogBrowserManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBrowserUiPlugin
extends AbstractUIPlugin {
    private static final Logger logger = LoggerFactory.getLogger(LogBrowserUiPlugin.class);
    private static final String EXTENSION_POINT_LOG_TEMPLATE_DIR = "com.vmware.vide.vlogbrowser.ui.logTemplateDir";
    private static final String TAG_EXTENSION_DIR = "dir";
    public static final String PLUGIN_ID = "com.vmware.vide.vlogbrowser.ui";
    public static final String COPYCLIP_IMG = "/icons/copyclip.png";
    public static final String FILTER_IMG = "/icons/filter.png";
    public static final String FIND_IMG = "/icons/find.png";
    public static final String FINDNEXT_IMG = "/icons/findnext.png";
    public static final String FIND_BY_DATE_IMG = "/icons/findbydate.png";
    public static final String HIGHLIGHT_IMG = "/icons/highlight.png";
    public static final String LOG_INFO_IMG = "/icons/loginfo.png";
    public static final String REFRESH_IMG = "/icons/refresh.png";
    public static final String VLOGBRSR_IMG = "/icons/vlogbrsr.png";
    public static final String ADD_LOG_FILES_IMG = "/icons/addlogfiles.png";
    public static final String UP_ARROW_IMG = "/icons/uparrow.png";
    public static final String DOWN_ARROW_IMG = "/icons/downarrow.png";
    public static final String CHECKED_IMG = "/icons/checked.png";
    public static final String UNCHECKED_IMG = "/icons/unchecked.png";
    public static final String WIZARD_IMG = "/icons/wizard.png";
    public static final String MARKER_IMG = "/icons/marker.png";
    public static final String ADD_HOST_IMG = "/icons/addhost.png";
    public static final String START_RECORDING_IMG = "/icons/start-record-16x16.png";
    public static final String STOP_RECORDING_IMG = "/icons/stop-record-16x16.png";
    private static LogBrowserUiPlugin plugin;
    private ILogBrowserManager manager;
    private IResourceChangeListener resourceListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.manager = new UiLogBrowserManager();
        String[] dirs = this.getAdditinonalDirsFromPluginsExtension();
        this.manager.setCustomTemplateDirs(dirs);
        this.resourceListener = new LogBrowserResourceChange();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    private String[] getAdditinonalDirsFromPluginsExtension() {
        ArrayList<String> additionalDirs = new ArrayList<String>();
        IConfigurationElement[] configElementList = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_LOG_TEMPLATE_DIR);
        try {
            IConfigurationElement[] iConfigurationElementArray = configElementList;
            int n = configElementList.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String tagName = configElement.getName();
                if (tagName.equals(TAG_EXTENSION_DIR)) {
                    File projectDir;
                    String pathValue = configElement.getValue();
                    Path dir = new Path(pathValue);
                    if (!dir.isAbsolute()) {
                        String bundleId = "?";
                        try {
                            bundleId = configElement.getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)bundleId);
                            URL fileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)dir, null));
                            dir = new Path(fileURL.getFile());
                        }
                        catch (IOException ex) {
                            throw new IOException("Error while parsing extension from bundle='" + bundleId + "' path='" + pathValue + "'", ex);
                        }
                    }
                    if ((projectDir = dir.toFile()).exists() && projectDir.isDirectory()) {
                        additionalDirs.add(dir.toOSString());
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), ex.getCause());
        }
        return additionalDirs.toArray(new String[additionalDirs.size()]);
    }

    public void stop(BundleContext context) throws Exception {
        this.manager.savePreferences();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        plugin = null;
        super.stop(context);
    }

    public static LogBrowserUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return LogBrowserUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        ImageRegistry imageRegistry = this.getImageRegistry();
        imageRegistry.put(COPYCLIP_IMG, LogBrowserUiPlugin.getImageDescriptor(COPYCLIP_IMG));
        imageRegistry.put(FILTER_IMG, LogBrowserUiPlugin.getImageDescriptor(FILTER_IMG));
        imageRegistry.put(FIND_IMG, LogBrowserUiPlugin.getImageDescriptor(FIND_IMG));
        imageRegistry.put(FINDNEXT_IMG, LogBrowserUiPlugin.getImageDescriptor(FINDNEXT_IMG));
        imageRegistry.put(FIND_BY_DATE_IMG, LogBrowserUiPlugin.getImageDescriptor(FIND_BY_DATE_IMG));
        imageRegistry.put(HIGHLIGHT_IMG, LogBrowserUiPlugin.getImageDescriptor(HIGHLIGHT_IMG));
        imageRegistry.put(LOG_INFO_IMG, LogBrowserUiPlugin.getImageDescriptor(LOG_INFO_IMG));
        imageRegistry.put(REFRESH_IMG, LogBrowserUiPlugin.getImageDescriptor(REFRESH_IMG));
        imageRegistry.put(VLOGBRSR_IMG, LogBrowserUiPlugin.getImageDescriptor(VLOGBRSR_IMG));
        imageRegistry.put(ADD_LOG_FILES_IMG, LogBrowserUiPlugin.getImageDescriptor(ADD_LOG_FILES_IMG));
        imageRegistry.put(ADD_HOST_IMG, LogBrowserUiPlugin.getImageDescriptor(ADD_HOST_IMG));
        imageRegistry.put(UP_ARROW_IMG, LogBrowserUiPlugin.getImageDescriptor(UP_ARROW_IMG));
        imageRegistry.put(DOWN_ARROW_IMG, LogBrowserUiPlugin.getImageDescriptor(DOWN_ARROW_IMG));
        imageRegistry.put(CHECKED_IMG, LogBrowserUiPlugin.getImageDescriptor(CHECKED_IMG));
        imageRegistry.put(UNCHECKED_IMG, LogBrowserUiPlugin.getImageDescriptor(UNCHECKED_IMG));
        imageRegistry.put(WIZARD_IMG, LogBrowserUiPlugin.getImageDescriptor(WIZARD_IMG));
        imageRegistry.put(MARKER_IMG, LogBrowserUiPlugin.getImageDescriptor(MARKER_IMG));
        imageRegistry.put(START_RECORDING_IMG, LogBrowserUiPlugin.getImageDescriptor(START_RECORDING_IMG));
        imageRegistry.put(STOP_RECORDING_IMG, LogBrowserUiPlugin.getImageDescriptor(STOP_RECORDING_IMG));
    }

    public Image getImage(String imageId) {
        return this.getImageRegistry().get(imageId);
    }

    public static void log(String errorMessage, Throwable t) {
        String pluginId = LogBrowserUiPlugin.getDefault().getBundle().getSymbolicName();
        Status status = new Status(4, pluginId, errorMessage, t);
        LogBrowserUiPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable t) {
        LogBrowserUiPlugin.log("Error", t);
    }

    public ILogBrowserManager getLogBrowserManager() {
        return this.manager;
    }
}

