/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui;

import com.vmware.vide.utils.resource.ResourceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    public static String getCurrentFileRealPath() {
        try {
            IEditorInput input;
            IEditorPart editor;
            IWorkbenchPage page;
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (win != null && (page = win.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
                return ((IFileEditorInput)input).getFile().getLocation().toOSString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IContainer getCurrentSelectedContainer() {
        try {
            ISelectionService service;
            IStructuredSelection selection;
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (win != null && (selection = (IStructuredSelection)(service = win.getSelectionService()).getSelection()) != null) {
                Object projectObj = selection.getFirstElement();
                if (projectObj instanceof IContainer) {
                    return (IContainer)projectObj;
                }
                if (projectObj instanceof IResource) {
                    IResource currentFile = (IResource)projectObj;
                    return currentFile.getParent();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCurrentSelectedContainerPath() {
        try {
            IContainer currentContainer = EditorUtils.getCurrentSelectedContainer();
            return ResourceUtils.getResourceAbsolutePath((IResource)currentContainer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

