/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis;

import com.vmware.vide.wbis.Activator;
import com.vmware.vide.wbis.ExtensionManager;
import com.vmware.vide.wbis.ImageUtil;
import com.vmware.vide.wbis.SimpleAction;
import com.vmware.vide.wbis.VMwarePopupMenusDescription;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.osgi.framework.Bundle;

public class PopupMenusContributionItem
extends ContributionItem {
    private static ILog logger = Activator.getDefault().getLog();

    public PopupMenusContributionItem() {
    }

    public PopupMenusContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        List<VMwarePopupMenusDescription> descs = ExtensionManager.INSTANCE.getVMwarePopupMenus();
        for (final VMwarePopupMenusDescription desc : descs) {
            String enablesFor;
            String style = desc.getStyle();
            if (style != null && !style.equals("push")) continue;
            int count = 0;
            if (this.isObjectContribution(desc) ? (count = this.countObjectSelected(desc)) == 0 : !this.isTargetIdAvailable(desc)) continue;
            final MenuItem item = new MenuItem(menu, 0, index);
            item.setText(desc.getName());
            if (desc.getImageDescriptor() != null) {
                if (desc.getImageDescriptor().getImageData().height > 16 || desc.getImageDescriptor().getImageData().width > 16) {
                    new Image((Device)item.getDisplay(), desc.getImageDescriptor().getImageData().scaledTo(16, 16));
                }
                item.setImage(ImageUtil.createMenuIconImage(desc.getImageDescriptor()));
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        item.getImage().dispose();
                    }
                });
            }
            if ((enablesFor = desc.getEnablesFor()) != null && desc.getObjectClass() != null) {
                this.enableMenuItemByEnablesFor(enablesFor, count, item);
                if (!item.isEnabled()) continue;
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Bundle bundle = desc.getBundle();
                    if (bundle == null) {
                        return;
                    }
                    try {
                        Class clazz = bundle.loadClass(desc.getActionClass());
                        IActionDelegate delegate = (IActionDelegate)clazz.newInstance();
                        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPart part = ww.getActivePage().getActivePart();
                        SimpleAction action = new SimpleAction(delegate);
                        if (delegate instanceof IObjectActionDelegate && part != null) {
                            ((IObjectActionDelegate)delegate).setActivePart((IAction)action, part);
                            ((IObjectActionDelegate)delegate).selectionChanged((IAction)action, ww.getSelectionService().getSelection());
                            ((IObjectActionDelegate)delegate).run((IAction)action);
                        } else if (delegate instanceof IViewActionDelegate && part instanceof IViewPart) {
                            ((IViewActionDelegate)delegate).init((IViewPart)part);
                            ((IViewActionDelegate)delegate).selectionChanged((IAction)action, ww.getSelectionService().getSelection());
                            ((IViewActionDelegate)delegate).run((IAction)action);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                    }
                    catch (InstantiationException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                    }
                    catch (IllegalAccessException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                    }
                }
            });
        }
    }

    private boolean isObjectContribution(VMwarePopupMenusDescription desc) {
        return desc.getObjectClass() != null;
    }

    private void enableMenuItemByEnablesFor(String enablesFor, int count, MenuItem item) {
        if (enablesFor.equals("!")) {
            if (count != 0) {
                item.setEnabled(false);
            }
        } else if (enablesFor.equals("?")) {
            if (count > 1) {
                item.setEnabled(false);
            }
        } else if (enablesFor.equals("+")) {
            if (count < 2) {
                item.setEnabled(false);
            }
        } else if (enablesFor.equals("multiple")) {
            if (count < 3) {
                item.setEnabled(false);
            }
        } else if (enablesFor.matches("\\d+")) {
            int num = Integer.parseInt(enablesFor);
            if (count != num) {
                item.setEnabled(false);
            }
        } else if (enablesFor.matches("\\d+\\+")) {
            int num = Integer.parseInt(enablesFor.substring(0, enablesFor.length() - 1));
            if (count < num) {
                item.setEnabled(false);
            }
        } else if (!enablesFor.equals("*")) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", String.format("Bad value [%s] for enablesFor.", enablesFor)));
        }
    }

    private int countObjectSelected(VMwarePopupMenusDescription desc) {
        Class objClass = null;
        try {
            Bundle bundle = desc.getBundle();
            objClass = bundle.loadClass(desc.getObjectClass());
        }
        catch (ClassNotFoundException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
            return 0;
        }
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelectionService service = ww.getSelectionService();
        ISelection s = service.getSelection();
        int count = 0;
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            Iterator it = ss.iterator();
            Pattern pattern = null;
            if (desc.getNameFilter() != null) {
                pattern = this.compileNameFilterPattern(desc.getNameFilter());
            }
            while (it.hasNext()) {
                String objectName;
                Matcher m;
                Object o = it.next();
                if (!objClass.isInstance(o)) {
                    return 0;
                }
                if (desc.isAdaptable()) {
                    if (!(o instanceof IAdaptable)) {
                        return 0;
                    }
                    if (((IAdaptable)o).getAdapter(IResource.class) == null) {
                        return 0;
                    }
                }
                if (pattern != null && !(m = pattern.matcher(objectName = objClass.cast(o).toString())).matches()) {
                    return 0;
                }
                ++count;
            }
        }
        return count;
    }

    private Pattern compileNameFilterPattern(String filter) {
        StringBuilder regexp = new StringBuilder();
        int index = 0;
        while (index < filter.length()) {
            int pos = filter.indexOf("*", index);
            if (pos == -1) {
                regexp.append(Pattern.quote(filter.substring(index)));
                break;
            }
            regexp.append(Pattern.quote(filter.substring(index, pos)));
            regexp.append(".*");
            index = pos + 1;
        }
        return Pattern.compile(regexp.toString());
    }

    private boolean isTargetIdAvailable(VMwarePopupMenusDescription desc) {
        String targetId = desc.getTargetId();
        if (targetId == null) {
            return false;
        }
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = ww.getActivePage().getActivePart();
        if (part != null && this.haveTargetId(part.getSite(), targetId)) {
            return true;
        }
        part = ww.getActivePage().getActiveEditor();
        if (part != null) {
            return this.haveTargetId(part.getSite(), targetId);
        }
        return false;
    }

    private boolean haveTargetId(IWorkbenchPartSite site, String id) {
        if (site instanceof PartSite) {
            PartSite partSite = (PartSite)site;
            String[] stringArray = partSite.getContextMenuIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String menuId = stringArray[n2];
                if (menuId.equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

