/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api;

import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.ITargetManagerProvider;
import com.vmware.vide.utils.local.VMWBConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class TargetManagerPlugin
extends Plugin {
    private static TargetManagerPlugin instance;
    private ITargetManager manager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }

    public static TargetManagerPlugin getDefault() {
        return instance;
    }

    public ITargetManager getTargetManager() {
        if (this.manager == null) {
            boolean headless = VMWBConfig.isHeadless();
            String id = this.getBundle().getSymbolicName();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(id, "provider");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        try {
                            String value = element.getAttribute("headless");
                            if (headless == Boolean.parseBoolean(value)) {
                                Object object = element.createExecutableExtension("class");
                                this.manager = ((ITargetManagerProvider)object).getTargetManager();
                                break block2;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            if (this.manager == null) {
                System.err.printf("Failed to create %s target manager implementation\n", headless ? "headless" : "normal");
            }
        }
        return this.manager;
    }

    public static ITargetManager getTheTargetManager() {
        return TargetManagerPlugin.getDefault().getTargetManager();
    }
}

