/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action.rpm;

public class RPMProvide {
    final String name;
    final String version;
    final String release;
    final String fullName;
    private final int hash;

    RPMProvide(String name, String version, String release) {
        this.name = name;
        this.version = version;
        this.release = release;
        this.fullName = name + '-' + version + '-' + release;
        this.hash = this.calcHash();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RPMProvide)) {
            return false;
        }
        RPMProvide other = (RPMProvide)obj;
        return this.name.equals(other.name) && this.version.equals(other.version) && this.release.equals(other.release);
    }

    public int hashCode() {
        return this.hash;
    }

    private int calcHash() {
        int value = this.calcHash(this.name.hashCode(), this.version.hashCode());
        return this.calcHash(value, this.release.hashCode());
    }

    private int calcHash(int base, int v) {
        return base << 5 + base << 2 + base + v;
    }
}

