/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action.rpm;

import com.vmware.vide.p2action.P2ActionPlugin;
import com.vmware.vide.p2action.rpm.RPMDescriptor;
import com.vmware.vide.p2action.rpm.RPMProvide;
import com.vmware.vide.p2action.rpm.RPMUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RPMInstallActionDependency {
    private static final ILog logger = P2ActionPlugin.getInstance().getLog();
    private final Path iuRpmDirPath;
    private final List<String> rpmFileNames;
    private final List<Path> artifactRpmRepositories;
    private final Map<RPMProvide, Boolean> provideInstalled = new HashMap<RPMProvide, Boolean>();
    private final Map<Object, RPMDescriptor> rpmDescriptors = new HashMap<Object, RPMDescriptor>();
    private final Map<Path, RPMState> rpmStates = new HashMap<Path, RPMState>();

    public RPMInstallActionDependency(Path iuRpmDirPath, List<String> rpmFileNames, List<Path> artifactRpmRepositories) {
        this.iuRpmDirPath = iuRpmDirPath;
        this.rpmFileNames = rpmFileNames;
        this.artifactRpmRepositories = artifactRpmRepositories;
    }

    public void calculate() throws CoreException {
        try {
            for (String rpmFileName : this.rpmFileNames) {
                Path rpmPath = Paths.get(this.iuRpmDirPath.toString(), rpmFileName);
                this.calculate(rpmPath);
            }
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "Faild to calculate the dependencies of the rpms.";
            }
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                msg = String.format("%s [%s].", msg, e.getCause().getMessage());
            }
            throw new CoreException((IStatus)new Status(4, "com.vmware.vide.p2action", msg, (Throwable)e));
        }
        catch (InterruptedException e) {
            String msg = "Canceled calcurating the rpm dependencies.";
            throw new CoreException((IStatus)new Status(8, "com.vmware.vide.p2action", msg, (Throwable)e));
        }
    }

    private void calculate(Path rpmPath) throws InterruptedException, IOException {
        try {
            RPMState rpmState = this.getRPMState(rpmPath);
            if (rpmState != null) {
                if (rpmState.isVisited()) {
                    return;
                }
                this.rpmStates.put(rpmState.descriptor.filePath(), rpmState);
                for (RPMDescriptor desc : rpmState.toBeInstalled) {
                    this.calculate(desc.filePath());
                }
                rpmState.markVisited();
            }
        }
        catch (IOException e) {
            String msg = String.format("Failed to calculate the dependencies and status of the rpm [%s].", rpmPath.toString());
            throw new IOException(msg, e);
        }
    }

    private RPMState getRPMState(Path rpmPath) throws InterruptedException, IOException {
        RPMState state = this.rpmStates.get(rpmPath);
        if (state != null) {
            return state;
        }
        RPMDescriptor descriptor = this.getRPMDescriptor(rpmPath);
        if (descriptor == null) {
            return null;
        }
        ArrayList<String> unresolved = new ArrayList<String>();
        ArrayList<RPMDescriptor> toBeInstalled = new ArrayList<RPMDescriptor>();
        for (String require : descriptor.requires) {
            RPMDescriptor desc = this.findRPM(require);
            if (desc != null) {
                if (this.isInstalled(desc)) continue;
                toBeInstalled.add(desc);
                continue;
            }
            unresolved.add(require);
        }
        return new RPMState(descriptor, this.isInstalled(descriptor), unresolved, toBeInstalled);
    }

    private RPMDescriptor findRPM(String rpmName) throws InterruptedException {
        RPMDescriptor desc = this.rpmDescriptors.get(rpmName);
        if (desc != null) {
            return desc;
        }
        for (Path rpmDirPath : this.artifactRpmRepositories) {
            if (!rpmDirPath.toFile().isDirectory()) continue;
            File[] fileArray = rpmDirPath.toFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    if (RPMUtil.isRPM(f.toPath()) && rpmName.equals((desc = this.getRPMDescriptor(f.toPath())).name())) {
                        return desc;
                    }
                }
                catch (IOException e) {
                    String msg = String.format("Failed to get the descriptor for the rpm [%s].", f.toPath().toString());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", msg, (Throwable)e));
                }
                ++n2;
            }
        }
        return null;
    }

    private RPMDescriptor getRPMDescriptor(Path rpmPath) throws InterruptedException, IOException {
        RPMDescriptor descriptor = this.rpmDescriptors.get(rpmPath);
        if (descriptor == null) {
            descriptor = RPMUtil.getRPMDescriptor(rpmPath);
            if (this.rpmDescriptors.containsKey(descriptor.name())) {
                descriptor = this.rpmDescriptors.get(descriptor.name());
                this.rpmDescriptors.put(rpmPath, descriptor);
            } else {
                this.rpmDescriptors.put(rpmPath, descriptor);
                this.rpmDescriptors.put(descriptor.name(), descriptor);
            }
        }
        return descriptor;
    }

    private boolean isInstalled(RPMDescriptor desc) throws InterruptedException, IOException {
        RPMProvide provide = desc.provide();
        if (this.provideInstalled.containsKey(provide)) {
            return this.provideInstalled.get(provide);
        }
        boolean b = RPMUtil.isRPMInstalled(provide.fullName);
        this.provideInstalled.put(provide, b);
        return b;
    }

    private void addToBeInstalled(RPMDescriptor desc, LinkedHashSet<Path> toBeInstalled) {
        RPMState state = this.rpmStates.get(desc.filePath());
        if (state != null) {
            if (state.isInstalled()) {
                return;
            }
            for (RPMDescriptor d : state.toBeInstalled) {
                this.addToBeInstalled(d, toBeInstalled);
            }
        }
        toBeInstalled.add(desc.filePath());
    }

    public List<Path> getRPMListToBeinstalled() throws CoreException {
        LinkedHashSet<Path> toBeInstalled = new LinkedHashSet<Path>();
        for (String rpmFileName : this.rpmFileNames) {
            Path rpmPath = Paths.get(this.iuRpmDirPath.toString(), rpmFileName);
            try {
                if (!RPMUtil.isRPM(rpmPath)) continue;
                RPMDescriptor desc = this.getRPMDescriptor(rpmPath);
                RPMState state = this.rpmStates.get(desc.filePath());
                if (state == null) {
                    String msg = String.format("Could not find the status of RPM [%s]. The rpm will not be installed.", rpmPath.toString());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", msg));
                    continue;
                }
                if (state.isInstalled()) continue;
                this.addToBeInstalled(desc, toBeInstalled);
            }
            catch (IOException e) {
                String msg = String.format("Could not get the information of the rpm [%s].", rpmPath.toString());
                throw new CoreException((IStatus)new Status(4, "com.vmware.vide.p2action", msg, (Throwable)e));
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(8, "com.vmware.vide.p2action", "Canel getting rpm list to be installed.", (Throwable)e));
            }
        }
        ArrayList<Path> rpms = new ArrayList<Path>();
        rpms.addAll(toBeInstalled);
        return rpms;
    }

    public List<RPMState> getUnresolved() {
        ArrayList<RPMState> unresolved = new ArrayList<RPMState>();
        for (String rpmFileName : this.rpmFileNames) {
            Path rpmPath = Paths.get(this.iuRpmDirPath.toString(), rpmFileName);
            RPMState state = this.rpmStates.get(rpmPath);
            if (state == null || state.unresolvedRpms.isEmpty()) continue;
            unresolved.add(state);
        }
        return unresolved;
    }

    public class RPMState {
        RPMDescriptor descriptor;
        Boolean installed;
        List<String> unresolvedRpms;
        List<RPMDescriptor> toBeInstalled;
        boolean visited;

        public RPMState(RPMDescriptor descriptor, boolean installed, List<String> unresolvedRpms, List<RPMDescriptor> toBeInstalled) {
            this.descriptor = descriptor;
            this.installed = installed;
            this.unresolvedRpms = unresolvedRpms;
            this.toBeInstalled = toBeInstalled;
            this.visited = false;
        }

        public RPMDescriptor descriptor() {
            return this.descriptor;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public List<String> unresolvedRequires() {
            return this.unresolvedRpms;
        }

        public boolean isVisited() {
            return this.visited;
        }

        public void markVisited() {
            this.visited = true;
        }
    }
}

