/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.ErrorReaderThread;
import com.vmware.vide.p2action.InstallRPMAction;
import com.vmware.vide.p2action.SimpleStdoutReaderThread;
import com.vmware.vide.p2action.vIDEInstallHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UninstallRPMAction
extends ProvisioningAction {
    private static final Logger logger = LoggerFactory.getLogger(UninstallRPMAction.class);
    private static final String ID = "uninstallrpm";
    private static List<String> uninstalledRPM = new ArrayList<String>();

    private static IStatus logAndCreateStatusError(String message, Throwable e) {
        logger.error(message, e);
        return new Status(4, ID, message);
    }

    public IStatus execute(Map parameters) {
        uninstalledRPM.clear();
        String install = vIDEInstallHelper.getInstallDir(parameters);
        if (install == null) {
            return UninstallRPMAction.logAndCreateStatusError("Can't find installation directory.", null);
        }
        File rpmDir = new File(String.valueOf(install) + "/rpm");
        List<String> rpms = vIDEInstallHelper.getRPMList(rpmDir, false);
        if (rpms.size() < 1) {
            logger.info("No rpms to unintall.");
            return null;
        }
        Collections.reverse(rpms);
        String nodeps = (String)parameters.get("nodeps");
        return UninstallRPMAction.uninstallRPMList(rpmDir, rpms, Boolean.valueOf(nodeps));
    }

    public IStatus undo(Map parameters) {
        String install;
        if (uninstalledRPM.size() > 0 && (install = vIDEInstallHelper.getInstallDir(parameters)) != null) {
            File rpmDir = new File(String.valueOf(install) + "/rpm");
            return InstallRPMAction.installRPMList(rpmDir, uninstalledRPM, true, false, true, true);
        }
        return null;
    }

    public static IStatus uninstallRPMList(File rpmDir, List<String> rpms, boolean nodeps) {
        IStatus returnValue = Status.OK_STATUS;
        for (String rpm : rpms) {
            RpmUninstallResult result = UninstallRPMAction.uninstallRPM(rpmDir, rpm, nodeps);
            if (result == RpmUninstallResult.SUCCESS) {
                uninstalledRPM.add(rpm);
                continue;
            }
            if (result == RpmUninstallResult.FAILED_STILL_NEEDED) continue;
            IStatus localStatus = UninstallRPMAction.logAndCreateStatusError("Failed to uninstall " + rpm, null);
            if (returnValue != Status.OK_STATUS) continue;
            returnValue = localStatus;
        }
        return returnValue;
    }

    public static RpmUninstallResult uninstallRPM(File rpmDir, String rpm, boolean nodeps) {
        RpmUninstallResult returnValue;
        block28: {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("rpm");
            arguments.add("-e");
            if (nodeps) {
                arguments.add("--nodeps");
            }
            if (!nodeps && vIDEInstallHelper.isRpmStillRequired(rpmDir, rpm)) {
                logger.info("Skipping uninstall of " + rpm + " as it is still required by other packages.");
                return RpmUninstallResult.FAILED_STILL_NEEDED;
            }
            returnValue = RpmUninstallResult.FAILED_OTHER;
            String rpmInfo = vIDEInstallHelper.getRpmName(rpmDir, rpm);
            if (rpmInfo != null && !rpmInfo.isEmpty()) {
                arguments.add(rpmInfo);
                Thread errReaderThread = null;
                Thread simpleReaderThread = null;
                StringBuilder cmd = new StringBuilder(100);
                for (String arg : arguments) {
                    cmd.append(" ").append(arg);
                }
                String commandString = cmd.toString();
                logger.info("Running" + commandString);
                try {
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
                        Process proc = processBuilder.start();
                        errReaderThread = new ErrorReaderThread(proc);
                        simpleReaderThread = new SimpleStdoutReaderThread(proc);
                        errReaderThread.start();
                        simpleReaderThread.start();
                        int retValue = proc.waitFor();
                        if (retValue == 0) {
                            returnValue = RpmUninstallResult.SUCCESS;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception while running '" + commandString + "'", (Throwable)e);
                        if (errReaderThread != null) {
                            try {
                                errReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (simpleReaderThread != null) {
                            try {
                                simpleReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (errReaderThread != null) {
                        try {
                            errReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (simpleReaderThread != null) {
                        try {
                            simpleReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    throw throwable;
                }
                if (errReaderThread != null) {
                    try {
                        errReaderThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (simpleReaderThread != null) {
                    try {
                        simpleReaderThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return returnValue;
    }

    public static enum RpmUninstallResult {
        SUCCESS,
        FAILED_STILL_NEEDED,
        FAILED_OTHER;

    }
}

