/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;

public class PhysicalMemoryCheckAction
extends ProvisioningAction {
    private static final String MEM_ERROR_FORMAT = "The system requires at least %d GB of memory to install this feature. Power down the virtual appliance to configure the proper memory amount.";
    private static final String MEM_GET_ERROR = "Unable to obtain system memory amount";
    private static final String MEMINFO_TOTAL_PREFIX = "MemTotal:";
    private static final int MEMINFO_MEM_INDEX = 1;

    private int getTotalMemoryGb() {
        int mem;
        block16: {
            mem = -1;
            BufferedReader reader = null;
            try {
                try {
                    FileInputStream stream = new FileInputStream(new File("/proc/meminfo"));
                    reader = new BufferedReader(new InputStreamReader(stream));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith(MEMINFO_TOTAL_PREFIX)) continue;
                        String[] parts = line.split("\\s+");
                        mem = Integer.parseInt(parts[1].trim());
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (mem != 1) {
            mem = Math.round((float)mem / 1048576.0f);
        }
        return mem;
    }

    public IStatus execute(Map<String, Object> parameters) {
        IStatus status = null;
        int requiredMemSize = Integer.parseInt((String)parameters.get("gb"));
        int currentMemSize = this.getTotalMemoryGb();
        if (currentMemSize != -1) {
            if (currentMemSize >= requiredMemSize) {
                status = Status.OK_STATUS;
            } else {
                String message = String.format(MEM_ERROR_FORMAT, requiredMemSize);
                status = new Status(4, "com.vmware.vide.p2action", message);
            }
        } else {
            status = new Status(4, "com.vmware.vide.p2action", MEM_GET_ERROR);
        }
        return status;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }
}

