/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.ErrorReaderThread;
import com.vmware.vide.p2action.P2ActionPlugin;
import com.vmware.vide.p2action.ProgressReaderThread;
import com.vmware.vide.p2action.SimpleStdoutReaderThread;
import com.vmware.vide.p2action.UninstallRPMAction;
import com.vmware.vide.p2action.rpm.RPMDescriptor;
import com.vmware.vide.p2action.rpm.RPMInstallActionDependency;
import com.vmware.vide.p2action.rpm.RPMUtil;
import com.vmware.vide.p2action.vIDEInstallHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallRPMAction
extends ProvisioningAction {
    private static final Logger logger = LoggerFactory.getLogger(InstallRPMAction.class);
    private static final String ID = "installrpm";
    private static List installedRPM = new ArrayList();
    private static final long DISPLAY_RPM_MIN_SIZE = 0x500000L;

    private static IStatus logAndCreateStatusError(String message, Throwable e) {
        logger.error(message, e);
        return new Status(4, ID, message);
    }

    public IStatus execute(Map parameters) {
        installedRPM.clear();
        String installedDir = vIDEInstallHelper.getInstallDir(parameters);
        if (installedDir == null) {
            return InstallRPMAction.logAndCreateStatusError("Can't find installation directory.", null);
        }
        File rpmDir = new File(String.valueOf(installedDir) + "/rpm");
        List<Object> rpms = vIDEInstallHelper.getRPMList(rpmDir, true);
        if (RPMUtil.hasRPMManifest(rpmDir.toPath())) {
            String installFolder = vIDEInstallHelper.getInstallFolder(parameters);
            if (installFolder == null) {
                return new Status(4, "com.vmware.vide.p2action", "Could not locate the eclipse installed directory.");
            }
            Path eclipseInstalledDirPath = Paths.get(installFolder, new String[0]);
            List<Path> rpmRepositoryPaths = this.getRPMRepositoryPaths(eclipseInstalledDirPath, rpmDir.toPath(), parameters);
            RPMInstallActionDependency dependency = new RPMInstallActionDependency(rpmDir.toPath(), rpms, rpmRepositoryPaths);
            try {
                dependency.calculate();
                IStatus status = this.reportUnsatisfiedRequires(dependency, parameters);
                if (status.getSeverity() == 4) {
                    return status;
                }
                List<Path> rpmPaths = dependency.getRPMListToBeinstalled();
                this.reportRpmListChanged(rpmDir.toPath(), rpmPaths);
                rpms = rpmPaths;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        if (rpms.size() < 1) {
            return null;
        }
        boolean nodeps = Boolean.parseBoolean((String)parameters.get("nodeps"));
        boolean install = Boolean.parseBoolean((String)parameters.get("install"));
        boolean oldpkg = Boolean.parseBoolean((String)parameters.get("oldpackage"));
        return InstallRPMAction.installRPMList(rpmDir, rpms, nodeps, true, install, oldpkg);
    }

    public IStatus undo(Map parameters) {
        String install;
        if (installedRPM.size() > 0 && (install = vIDEInstallHelper.getInstallDir(parameters)) != null) {
            File rpmDir = new File(String.valueOf(install) + "/rpm");
            return UninstallRPMAction.uninstallRPMList(rpmDir, installedRPM, true);
        }
        return null;
    }

    public static IStatus installRPMList(File iuRpmDir, List rpms, boolean nodeps, boolean showUI, boolean install, boolean oldpkg) {
        int i = 0;
        while (i < rpms.size()) {
            String rpm = null;
            File rpmDir = null;
            Object o = rpms.get(i);
            if (o instanceof Path) {
                Path rpmPath = (Path)o;
                rpmDir = rpmPath.getParent().toFile();
                rpm = rpmPath.getFileName().toString();
            } else {
                rpm = (String)rpms.get(i);
                rpmDir = iuRpmDir;
            }
            int retVal = showUI ? InstallRPMAction.installRPM(rpmDir, rpm, nodeps, install, oldpkg) : InstallRPMAction.installRPMHeadless(rpmDir, rpm, nodeps, install, oldpkg);
            if (retVal != 0) {
                return InstallRPMAction.logAndCreateStatusError("Failed to install " + rpm + ": return code " + retVal, null);
            }
            InstallRPMAction.workaroundPr1376181(rpm);
            installedRPM.add(rpm);
            ++i;
        }
        return Status.OK_STATUS;
    }

    private static void workaroundPr1376181(String rpm) {
        block33: {
            if (rpm.startsWith("vmware-esx-vib-suite-6")) {
                try {
                    logger.info("It appears we just installed vib-suite.  Checking to see if we need to work around the update issue for PR 1376181...");
                    Pattern pattern = Pattern.compile("vmware-esx-vib-suite-([0-9\\.]+)-[0-9]\\.[0-9]\\.([0-9]+)\\..*");
                    Matcher m = pattern.matcher(rpm);
                    if (!m.matches()) break block33;
                    String versionMajorMinor = m.group(1);
                    String buildNumber = m.group(2);
                    String vibbasepath = "/opt/vmware/vibtools-" + versionMajorMinor + "-" + buildNumber;
                    Path newVibBasePath = FileSystems.getDefault().getPath(vibbasepath, new String[0]);
                    if (!Files.isDirectory(newVibBasePath, new LinkOption[0])) break block33;
                    logger.info("New directory '{}' exists, checking links...", (Object)newVibBasePath);
                    Path vibToolsLink = FileSystems.getDefault().getPath("/opt/vmware/vibtools", new String[0]);
                    InstallRPMAction.checkSymlinkAndRecreateIfNecessary(newVibBasePath, vibToolsLink);
                    Path vibAuthorLink = FileSystems.getDefault().getPath("/usr/bin/vibauthor", new String[0]);
                    Path vibAuthorTarget = FileSystems.getDefault().getPath(vibbasepath, "bin", "vibauthor");
                    InstallRPMAction.checkSymlinkAndRecreateIfNecessary(vibAuthorTarget, vibAuthorLink);
                    Path vibPublishTarget = FileSystems.getDefault().getPath(vibbasepath, "bin", "vibpublish");
                    if (Files.exists(vibPublishTarget, new LinkOption[0])) {
                        Path vibPublishLink = FileSystems.getDefault().getPath("/usr/bin/vibpublish", new String[0]);
                        InstallRPMAction.checkSymlinkAndRecreateIfNecessary(vibPublishTarget, vibPublishLink);
                    } else {
                        logger.info("'{}' does not exist, skipping.", (Object)vibPublishTarget);
                    }
                    Path manFilePath = FileSystems.getDefault().getPath("/etc/man.config", new String[0]);
                    boolean manDotConfigExists = Files.exists(manFilePath, new LinkOption[0]);
                    if (!manDotConfigExists) {
                        manFilePath = FileSystems.getDefault().getPath("/etc/manpath.config", new String[0]);
                    }
                    if (!Files.exists(manFilePath, new LinkOption[0])) break block33;
                    Path newVibManPath = FileSystems.getDefault().getPath(vibbasepath, "doc", "man");
                    File manConfigTempFile = File.createTempFile("man-config", null);
                    manConfigTempFile.delete();
                    String command = String.format("grep -v %s %s > %s; mv %s %s", "/opt/vmware/vibtools-", manFilePath.toString(), manConfigTempFile.getAbsolutePath(), manConfigTempFile.getAbsolutePath(), manFilePath.toString());
                    logger.info("Running command to remove all previous vib man entries '" + command + "'");
                    Thread errReaderThread = null;
                    Thread simpleReaderThread = null;
                    try {
                        try {
                            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", command);
                            Process proc = processBuilder.start();
                            errReaderThread = new ErrorReaderThread(proc);
                            simpleReaderThread = new SimpleStdoutReaderThread(proc);
                            errReaderThread.start();
                            simpleReaderThread.start();
                            proc.waitFor();
                        }
                        catch (Exception e) {
                            logger.error("Exception running '" + command + "'", (Throwable)e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        if (errReaderThread != null) {
                            try {
                                errReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (simpleReaderThread != null) {
                            try {
                                simpleReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        throw throwable;
                    }
                    if (errReaderThread != null) {
                        try {
                            errReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (simpleReaderThread != null) {
                        try {
                            simpleReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    logger.info("Now appending new lines to {}", (Object)manFilePath.toString());
                    Throwable throwable = null;
                    Object var19_22 = null;
                    try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(manFilePath.toString(), true)));){
                        if (manDotConfigExists) {
                            out.println("MANPATH  " + newVibManPath.toString());
                        }
                        out.println("MANPATH_MAP  " + vibbasepath + "/bin " + newVibManPath.toString());
                        out.println("MANPATH_MAP  /usr/bin " + newVibManPath.toString());
                        if (!manDotConfigExists) {
                            out.println("MANDB_MAP " + newVibManPath.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.error("Unhandled exception while trying to workaround PR 1376181. ", (Throwable)e);
                }
            }
        }
    }

    private static void checkSymlinkAndRecreateIfNecessary(Path linkTarget, Path link) throws IOException {
        if (Files.isSymbolicLink(link)) {
            Path currentLinkTarget = Files.readSymbolicLink(link);
            if (!Files.exists(currentLinkTarget, new LinkOption[0]) || !Files.isSameFile(currentLinkTarget, linkTarget)) {
                logger.info("link '{}' exists, but currently resolves to '{}'. Relinking it to '{}'", new Object[]{link, currentLinkTarget, linkTarget});
                logger.info("unlinking '{}'", (Object)link);
                Files.delete(link);
                logger.info("Creating link from '{}' > '{}'", (Object)link, (Object)linkTarget);
                Files.createSymbolicLink(link, linkTarget, new FileAttribute[0]);
            } else {
                logger.info("link '{}' exists and resolves to '{}' which is the same as '{}'. Ignoring it.", new Object[]{link, currentLinkTarget, linkTarget});
            }
        }
    }

    private static StringBuffer buildRPMCommand(String rpm, boolean nodeps, boolean percent, boolean install, boolean oldpkg) {
        StringBuffer command = new StringBuffer("rpm ");
        if (install) {
            command.append("-i ");
        } else {
            command.append("-U ");
        }
        if (percent) {
            command.append("--percent ");
        }
        if (nodeps) {
            command.append("--nodeps ");
        }
        if (oldpkg) {
            command.append("--oldpackage ");
        }
        command.append(rpm);
        return command;
    }

    /*
     * Loose catch block
     */
    private static int installRPMHeadless(File rpmDir, String rpm, boolean nodeps, boolean install, boolean oldpkg) {
        int n;
        Thread simpleReaderThread;
        Thread errReaderThread;
        String commandString;
        block20: {
            StringBuffer command = InstallRPMAction.buildRPMCommand(rpm, nodeps, false, install, oldpkg);
            commandString = command.toString();
            logger.info("Running '" + commandString + "'");
            errReaderThread = null;
            simpleReaderThread = null;
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", commandString);
            processBuilder.directory(rpmDir);
            Process proc = processBuilder.start();
            errReaderThread = new ErrorReaderThread(proc);
            simpleReaderThread = new SimpleStdoutReaderThread(proc);
            errReaderThread.start();
            simpleReaderThread.start();
            n = proc.waitFor();
            if (errReaderThread == null) break block20;
            try {
                errReaderThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (simpleReaderThread != null) {
            try {
                simpleReaderThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return n;
        catch (Exception e) {
            block21: {
                try {
                    logger.error("Exception running '" + commandString + "'", (Throwable)e);
                    if (errReaderThread == null) break block21;
                }
                catch (Throwable throwable) {
                    if (errReaderThread != null) {
                        try {
                            errReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (simpleReaderThread != null) {
                        try {
                            simpleReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    throw throwable;
                }
                try {
                    errReaderThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (simpleReaderThread != null) {
                try {
                    simpleReaderThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return -1;
    }

    private static int installRPM(final File rpmDir, final String rpm, final boolean nodeps, final boolean install, final boolean oldpkg) {
        final int[] retVal = new int[]{-1};
        final IRunnableWithProgress installRpm = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                block23: {
                    String message = "Installing " + rpm + "...";
                    monitor.beginTask(message, 100);
                    StringBuffer command = InstallRPMAction.buildRPMCommand(rpm, nodeps, true, install, oldpkg);
                    String commandString = command.toString();
                    logger.info("Running '" + commandString + "'");
                    Thread errReaderThread = null;
                    Thread progressReaderThread = null;
                    try {
                        try {
                            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", command.toString());
                            processBuilder.directory(rpmDir);
                            Process proc = processBuilder.start();
                            errReaderThread = new ErrorReaderThread(proc);
                            errReaderThread.start();
                            progressReaderThread = new ProgressReaderThread(proc, monitor);
                            progressReaderThread.start();
                            retVal[0] = proc.waitFor();
                        }
                        catch (Exception e) {
                            logger.error("Exception running '" + commandString + "'", (Throwable)e);
                            if (errReaderThread != null) {
                                try {
                                    errReaderThread.join();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (progressReaderThread != null) {
                                try {
                                    progressReaderThread.join();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            monitor.done();
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (errReaderThread != null) {
                            try {
                                errReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (progressReaderThread != null) {
                            try {
                                progressReaderThread.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        monitor.done();
                        throw throwable;
                    }
                    if (errReaderThread != null) {
                        try {
                            errReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (progressReaderThread != null) {
                        try {
                            progressReaderThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    monitor.done();
                }
            }
        };
        try {
            if (new File(rpmDir, rpm).length() < 0x500000L) {
                throw new IllegalStateException("Hiding RPM install progress");
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    try {
                        dialog.run(true, false, installRpm);
                    }
                    catch (Exception e) {
                        logger.error("Exception while running install dialog", (Throwable)e);
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            retVal[0] = InstallRPMAction.installRPMHeadless(rpmDir, rpm, nodeps, install, oldpkg);
        }
        return retVal[0];
    }

    private List<Path> getRPMRepositoryPaths(Path eclipseInstallDirPath, Path iuRpmDirPath, Map<String, Object> parameters) {
        IInstallableUnit iu = vIDEInstallHelper.getInstallableUnit(parameters);
        ProvisioningContext context = vIDEInstallHelper.getProvisioningContext(parameters);
        List<IArtifactRepository> repositories = vIDEInstallHelper.getArtifactRepositories(context);
        List<IArtifactRepository> artifactRepositories = vIDEInstallHelper.findArtifactRepositoriesByIUID(iu.getId(), iu.getVersion(), repositories);
        LinkedHashSet<IArtifactRepository> quarifiedRepositories = new LinkedHashSet<IArtifactRepository>();
        for (IArtifactRepository repository : artifactRepositories) {
            URI uri = repository.getLocation();
            if ("file".equals(uri.getScheme()) && eclipseInstallDirPath.equals(Paths.get(uri.getPath(), new String[0]))) continue;
            quarifiedRepositories.add(repository);
        }
        ArrayList<Path> rpmDirectoryPaths = new ArrayList<Path>(vIDEInstallHelper.getRPMDirectoriesInArtifactRepositories(eclipseInstallDirPath, iuRpmDirPath, new ArrayList<IArtifactRepository>(quarifiedRepositories)));
        return rpmDirectoryPaths;
    }

    private void reportRpmListChanged(Path rpmDirPath, List<Path> rpmPaths) {
        ILog logger = P2ActionPlugin.getInstance().getLog();
        for (Path rpmPath : rpmPaths) {
            if (rpmPath.startsWith(rpmDirPath)) continue;
            String msg = String.format("The rpm [%s] is not found in the repository [%s]. The rpm will be installed from the other repository [%s].", rpmPath.getFileName().toString(), rpmDirPath.toString(), rpmPath.getParent().toString());
            logger.log((IStatus)new Status(1, "com.vmware.vide.p2action", msg));
        }
    }

    private IStatus reportUnsatisfiedRequires(RPMInstallActionDependency dependency, Map<String, Object> parameters) {
        List<RPMInstallActionDependency.RPMState> unsatisfiedRpms = dependency.getUnresolved();
        IStatus status = Status.OK_STATUS;
        if (!unsatisfiedRpms.isEmpty()) {
            ILog logger = P2ActionPlugin.getInstance().getLog();
            String FMT = "The rpm [%s] requires %s, but they are not satisfied.";
            StringBuilder sb = new StringBuilder();
            for (RPMInstallActionDependency.RPMState state : unsatisfiedRpms) {
                RPMDescriptor desc = state.descriptor();
                String rpmFileName = desc.filePath().getFileName().toString();
                sb.append(String.format(FMT, rpmFileName, state.unresolvedRequires())).append('\n');
            }
            int severity = Boolean.parseBoolean((String)parameters.get("nodeps")) ? 2 : 4;
            status = new Status(severity, "com.vmware.vide.p2action", sb.toString());
            logger.log(status);
        }
        return status;
    }
}

