/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.model;

import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.model.XMLAttribute;
import com.vmware.vide.vxmleditor.model.XMLData;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.model.XMLRootData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNode
extends XMLData {
    private static final String NODE_SEPARATOR = ":";
    protected List<XMLNode> children;
    protected Map<String, XMLAttribute> attributes;

    public XMLNode(XMLData parent, Schema schema, Node node, boolean skipcomment) {
        super(parent, schema, node);
        this.attributes = XMLNode.collectAttributes(this, this.schemaelement, this.xmlnode);
        this.children = XMLNode.collectChildren(this, schema, this.xmlnode, skipcomment);
    }

    public XMLNode(XMLNode parent, Node node, boolean skipcomment) {
        this(parent, parent.getSchema(), node, skipcomment);
    }

    public XMLNode[] getChildren(boolean ignoretextnode) {
        if (ignoretextnode && this.getTextNode(false) != null) {
            return new XMLNode[0];
        }
        return this.children.toArray(new XMLNode[this.children.size()]);
    }

    public XMLNode[] getChildrenWithComments() {
        List<XMLNode> children = XMLNode.collectChildren(this, this.getSchema(), this.xmlnode, false);
        return children.toArray(new XMLNode[children.size()]);
    }

    public Map<String, XMLAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean hasChildren() {
        return this.getChildren(true).length > 0;
    }

    @Override
    public String getText() {
        if (this.xmlnode.getNodeName() != null && !this.xmlnode.getNodeName().isEmpty()) {
            return this.xmlnode.getNodeName();
        }
        if (this.xmlnode.getNodeType() == 3) {
            return this.xmlnode.getNodeValue();
        }
        return "";
    }

    public boolean hasThisAttribute(Object attr) {
        return attr instanceof XMLAttribute && this.attributes.containsKey(((XMLAttribute)attr).getName());
    }

    public boolean isLeafTextNode() {
        Node textnode = this.getTextNode(false);
        if (textnode != null) {
            return true;
        }
        return this.schemaelement == null || this.schemaelement.getType() == null || this.schemaelement.getType().elems == null || this.schemaelement.getType().elems.size() == 0;
    }

    public boolean hasText() {
        Node textnode = this.getTextNode(false);
        if (textnode != null) {
            return true;
        }
        if (this.schemaelement != null && this.schemaelement.getType() != null) {
            Schema.Type t = this.schemaelement.getType();
            if (t.isSimple()) {
                return true;
            }
            if (t.isComplex() && t.isMixedModel()) {
                return true;
            }
        }
        return false;
    }

    public String getTextNodeValue() {
        Node node = this.getTextNode(false);
        return node != null ? node.getNodeValue() : "";
    }

    public void setTextNodeValue(String text, boolean create) {
        Node node = this.getTextNode(create);
        if (node != null) {
            node.setNodeValue(text);
        }
    }

    private Node getTextNode(boolean create) {
        Node node;
        if (this.children.size() == 1 && (node = ((XMLNode)this.children.toArray()[0]).getNode()).getNodeType() == 3) {
            return node;
        }
        if (create) {
            node = this.xmlnode.getOwnerDocument().createTextNode("");
            this.children.add(new XMLNode(this, node, true));
            this.xmlnode.appendChild(node);
            return node;
        }
        return null;
    }

    public void updated(Object object, String text) {
        if (object == this) {
            this.setTextNodeValue(text, true);
        } else if (this.hasThisAttribute(object)) {
            XMLAttribute attr = (XMLAttribute)object;
            if (text == null || text.isEmpty()) {
                attr.removeAttribute();
            } else {
                attr.setAttributeValue(text);
            }
        }
        this.fireDataChanged(2);
    }

    @Override
    public boolean getBooleanValue() {
        if (this.isBoolean()) {
            return this.getBooleanValue(this.getTextNodeValue());
        }
        return false;
    }

    public String getDescriptionFromSchema() {
        return this.schemaelement != null ? this.schemaelement.contextInfomationDescription : null;
    }

    public void fireDataChanged(int type) {
        XMLData rootnode = this.parent;
        while (rootnode != null && !(rootnode instanceof XMLRootData)) {
            rootnode = rootnode.parent;
        }
        if (rootnode != null) {
            XMLDataModel model = ((XMLRootData)rootnode).getDataModel();
            model.fireModelChanged(type, this);
        }
    }

    public void cleanupNode() {
        for (XMLNode child : this.children) {
            child.cleanupNode();
        }
        this.children.clear();
        this.xmlnode.getParentNode().removeChild(this.xmlnode);
    }

    public void removeChildNode(XMLNode child) {
        if (!this.children.contains(child)) {
            return;
        }
        child.cleanupNode();
        this.children.remove(child);
        this.fireDataChanged(5);
    }

    public void removeChildNodeIncludingComment(XMLNode child) {
        child.cleanupNode();
        this.children.remove(child);
        this.fireDataChanged(5);
    }

    public void appendChildNode(Object element) {
        if (element == null || !(element instanceof Schema.Elem)) {
            System.out.println("Invalid schema information");
            return;
        }
        Schema.Elem elem = (Schema.Elem)element;
        Element node = this.xmlnode.getOwnerDocument().createElement(elem.getName());
        this.xmlnode.appendChild(node);
        this.children.add(new XMLNode(this, node, true));
        this.fireDataChanged(4);
    }

    public void appendCommentNode(String content) {
        Comment comment = this.xmlnode.getOwnerDocument().createComment(content);
        this.xmlnode.appendChild(comment);
        this.fireDataChanged(4);
    }

    public void appendChildNode(Object element, String content) {
        if (element == null || !(element instanceof Schema.Elem)) {
            System.out.println("Invalid schema information");
            return;
        }
        Schema.Elem elem = (Schema.Elem)element;
        Element node = this.xmlnode.getOwnerDocument().createElement(elem.getName());
        node.setTextContent(content);
        this.xmlnode.appendChild(node);
        this.children.add(new XMLNode(this, node, true));
        this.fireDataChanged(4);
    }

    public Object[] getSchemaElements() {
        Schema.Type type;
        ArrayList<Schema.Elem> elements = new ArrayList<Schema.Elem>();
        if (this.schemaelement != null && (type = this.schemaelement.getType()) != null && type.elems.size() > 0) {
            for (Schema.Elem elem : type.elems) {
                if (elem.getType() != null && elem.getTagType().equals("group")) {
                    elements.addAll(elem.getType().elems);
                    continue;
                }
                elements.add(elem);
            }
        }
        return elements.toArray();
    }

    public List<Schema.Elem> getSchemaAttributes() {
        Schema.Type t;
        if (this.schemaelement != null && (t = this.schemaelement.getType()) != null) {
            return t.attrs;
        }
        return null;
    }

    private XMLNode findNode(List<XMLNode> nodes, String nodetext) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        for (XMLNode node : nodes) {
            if (!node.getText().equals(nodetext)) continue;
            return node;
        }
        return null;
    }

    public String getFullNodeText() {
        String key = this.getText();
        XMLData history = this.parent;
        while (history != null) {
            key = String.valueOf(history.getText()) + NODE_SEPARATOR + key;
            history = history.parent;
        }
        return key;
    }

    public XMLNode[] getNodesFromFullNodeText(String fullnodetext) {
        String[] nodetexts = fullnodetext.split(NODE_SEPARATOR);
        if (nodetexts.length == 0 || !nodetexts[0].equals(this.getText())) {
            return new XMLNode[0];
        }
        ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
        nodes.add(this);
        int index = 1;
        List<XMLNode> cnodes = this.children;
        while (index < nodetexts.length) {
            XMLNode child = this.findNode(cnodes, nodetexts[index]);
            if (child == null) break;
            ++index;
            cnodes = child.children;
            nodes.add(child);
        }
        return nodes.toArray(new XMLNode[nodes.size()]);
    }

    public static String getSchemaName(Object object) {
        return object instanceof Schema.Elem ? ((Schema.Elem)object).getName() : "";
    }

    private static List<XMLNode> collectChildren(XMLData parent, Schema schema, Node node, boolean skipcomment) {
        ArrayList<XMLNode> childnodes = new ArrayList<XMLNode>();
        NodeList nodelist = node.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node child = nodelist.item(i);
            if (!(child.getNodeType() == 3 && (child.getNodeValue() == null || child.getNodeValue().trim().isEmpty()) || skipcomment && child.getNodeType() == 8)) {
                childnodes.add(new XMLNode(parent, schema, child, skipcomment));
            }
            ++i;
        }
        return childnodes;
    }

    private static Map<String, XMLAttribute> collectAttributes(XMLData parent, Schema.Elem element, Node node) {
        LinkedHashMap<String, XMLAttribute> attrs = new LinkedHashMap<String, XMLAttribute>();
        Schema.Type type = element != null ? element.getType() : null;
        NamedNodeMap nodeattrs = node.getAttributes();
        if (nodeattrs != null) {
            int i = 0;
            while (i < nodeattrs.getLength()) {
                Node attrnode = nodeattrs.item(i);
                String attrname = attrnode.getNodeName();
                boolean attrcreated = false;
                if (type != null) {
                    for (Schema.Elem attrelem : type.attrs) {
                        if (!attrelem.getName().equals(attrname)) continue;
                        XMLAttribute xmlattr = new XMLAttribute(parent, attrelem);
                        xmlattr.setAttributeNode(attrnode);
                        attrs.put(attrname, xmlattr);
                        attrcreated = true;
                    }
                }
                if (!attrcreated) {
                    XMLAttribute xmlattr = new XMLAttribute(parent, null);
                    xmlattr.setAttributeNode(attrnode);
                    xmlattr.setAttributeName(attrname);
                    attrs.put(attrname, xmlattr);
                }
                ++i;
            }
        }
        if (type != null) {
            for (Schema.Elem attr : type.attrs) {
                if (attrs.containsKey(attr.getName())) continue;
                attrs.put(attr.getName(), new XMLAttribute(parent, attr));
            }
        }
        return attrs;
    }

    public XMLData getParentData() {
        return this.parent;
    }
}

