/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import com.vmware.vide.vxmleditor.Activator;
import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.editors.ColorManager;
import com.vmware.vide.vxmleditor.editors.NonRuleBasedDamagerRepairer;
import com.vmware.vide.vxmleditor.editors.TagContentAssistProcessor;
import com.vmware.vide.vxmleditor.editors.TextFormattingStrategy;
import com.vmware.vide.vxmleditor.editors.VXMLFormattingStrategy;
import com.vmware.vide.vxmleditor.editors.XMLDoubleClickStrategy;
import com.vmware.vide.vxmleditor.editors.XMLScanner;
import com.vmware.vide.vxmleditor.editors.XMLTagScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.xml.sax.SAXException;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;
    public ContentFormatter formatter;
    private String XSDFile;

    public XMLConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag", "__xml_text", "__xml_pi", "__xml_doctype"};
    }

    public void setXSDFile(String XSDFile) {
        this.XSDFile = XSDFile;
    }

    public String getXSDFile() {
        return this.XSDFile;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(Activator.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(Activator.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_pi");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_pi");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_doctype");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(Activator.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        TagContentAssistProcessor tagContentAssistProcessor = new TagContentAssistProcessor(this.XSDFile);
        assistant.setContentAssistProcessor((IContentAssistProcessor)tagContentAssistProcessor, "__xml_tag");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.install((ITextViewer)sourceViewer);
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.formatter == null) {
            this.formatter = new ContentFormatter();
            VXMLFormattingStrategy xts1 = new VXMLFormattingStrategy();
            TextFormattingStrategy txt = new TextFormattingStrategy();
            this.formatter.setFormattingStrategy((IFormattingStrategy)xts1, "__xml_tag");
            this.formatter.setFormattingStrategy((IFormattingStrategy)txt, "__xml_text");
            this.formatter.setFormattingStrategy((IFormattingStrategy)txt, "__xml_comment");
        }
        return this.formatter;
    }

    public Schema getSchemaObject() {
        Schema sch = new Schema();
        try {
            sch.parseXml(this.XSDFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return sch;
    }
}

